/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class JUnitAbstractTestClassNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 12;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("j.unit.abstract.test.class.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnitAbstractTestClassNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String className = (String)infos[0];
        if (className.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("j.unit.abstract.test.class.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnitAbstractTestClassNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("j.unit.abstract.test.class.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnitAbstractTestClassNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("j.unit.abstract.test.class.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/JUnitAbstractTestClassNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*TestCase";
    }

    @Override
    protected int getDefaultMinLength() {
        return 12;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/JUnitAbstractTestClassNamingConventionInspection$NamingConventionsVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "junit.framework.TestCase")) {
                return;
            }
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (JUnitAbstractTestClassNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

