/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstantJUnitAssertArgumentInspection
extends BaseInspection {
    private static final Set<String> ASSERT_METHODS = new HashSet<String>();

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Constant JUnit assert argument" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/ConstantJUnitAssertArgumentInspection.getDisplayName must not return null");
        }
        return "Constant JUnit assert argument";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Argument <code>#ref</code> is constant" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/ConstantJUnitAssertArgumentInspection.buildErrorString must not return null");
        }
        return "Argument <code>#ref</code> is constant";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantJUnitAssertArugmentVisitor();
    }

    static {
        ASSERT_METHODS.add("assertTrue");
        ASSERT_METHODS.add("assertFalse");
        ASSERT_METHODS.add("assertNull");
        ASSERT_METHODS.add("assertNotNull");
    }

    private static class ConstantJUnitAssertArugmentVisitor
    extends BaseInspectionVisitor {
        private ConstantJUnitAssertArugmentVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!ASSERT_METHODS.contains(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!ClassUtils.isSubclass(containingClass, "junit.framework.Assert") && !ClassUtils.isSubclass(containingClass, "org.junit.Assert")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            if (!PsiUtil.isConstantExpression((PsiExpression)lastArgument)) {
                return;
            }
            this.registerError((PsiElement)lastArgument, new Object[0]);
        }
    }
}

