/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AbstractClassWithOnlyOneDirectInheritorInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.class.with.only.one.direct.inheritor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/AbstractClassWithOnlyOneDirectInheritorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.class.with.only.one.direct.inheritor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/AbstractClassWithOnlyOneDirectInheritorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassWithOnlyOneDirectInheritorVisitor();
    }

    private static class AbstractClassWithOnlyOneDirectInheritorVisitor
    extends BaseInspectionVisitor {
        private AbstractClassWithOnlyOneDirectInheritorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/AbstractClassWithOnlyOneDirectInheritorInspection$AbstractClassWithOnlyOneDirectInheritorVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!AbstractClassWithOnlyOneDirectInheritorVisitor.hasOneInheritor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static boolean hasOneInheritor(final PsiClass aClass) {
            final SearchScope searchScope = aClass.getUseScope();
            final PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(2);
            ProgressManager instance = ProgressManager.getInstance();
            instance.runProcess(new Runnable(){

                @Override
                public void run() {
                    ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
                }
            }, null);
            Collection collection = processor.getCollection();
            return collection.size() == 1;
        }
    }
}

