/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantMethodOverrideInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.method.override.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/RedundantMethodOverrideInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/RedundantMethodOverrideInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantMethodOverrideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantMethodOverrideVisitor();
    }

    private static class RedundantMethodOverrideVisitor
    extends BaseInspectionVisitor {
        private RedundantMethodOverrideVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            Query superMethodQuery = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false);
            MethodSignatureBackedByPsiMethod signature = (MethodSignatureBackedByPsiMethod)superMethodQuery.findFirst();
            if (signature == null) {
                return;
            }
            PsiMethod superMethod = signature.getMethod();
            PsiCodeBlock superBody = superMethod.getBody();
            if (superBody == null) {
                return;
            }
            PsiModifierList superModifierList = superMethod.getModifierList();
            PsiModifierList modifierList = method.getModifierList();
            if (!EquivalenceChecker.modifierListsAreEquivalent(modifierList, superModifierList)) {
                return;
            }
            PsiType superReturnType = superMethod.getReturnType();
            if (superReturnType == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (!superReturnType.equals(returnType)) {
                return;
            }
            if (!EquivalenceChecker.codeBlocksAreEquivalent(body, superBody)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }

    private static class RedundantMethodOverrideFix
    extends InspectionGadgetsFix {
        private RedundantMethodOverrideFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("redundant.method.override.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/RedundantMethodOverrideInspection$RedundantMethodOverrideFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            RedundantMethodOverrideFix.deleteElement(method);
        }
    }
}

