/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.NotNull;

public class SamePackageImportInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("import.from.same.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/SamePackageImportInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("import.from.same.package.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/SamePackageImportInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SamePackageImportVisitor();
    }

    private static class SamePackageImportVisitor
    extends BaseInspectionVisitor {
        private SamePackageImportVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiImportStatement[] importStatements;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/SamePackageImportInspection$SamePackageImportVisitor.visitClass must not be null");
            }
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            if (JspPsiUtil.isInJspFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)aClass.getParent();
            if (file == null) {
                return;
            }
            if (!file.getClasses()[0].equals(aClass)) {
                return;
            }
            String packageName = file.getPackageName();
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
                if (reference == null) continue;
                String text = importStatement.getQualifiedName();
                if (importStatement.isOnDemand()) {
                    if (!packageName.equals(text)) continue;
                    this.registerError((PsiElement)importStatement, new Object[0]);
                    continue;
                }
                if (text == null) {
                    return;
                }
                int classNameIndex = text.lastIndexOf(46);
                String parentName = classNameIndex < 0 ? "" : text.substring(0, classNameIndex);
                if (!packageName.equals(parentName)) continue;
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }
    }
}

