/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TooBroadCatchInspection
extends BaseInspection {
    public boolean onlyWarnOnRootExceptions = false;

    @NotNull
    public String getID() {
        if ("OverlyBroadCatchBlock" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/TooBroadCatchInspection.getID must not return null");
        }
        return "OverlyBroadCatchBlock";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.catch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/TooBroadCatchInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        List typesMasked = (List)infos[0];
        String typesMaskedString = ((PsiType)typesMasked.get(0)).getPresentableText();
        if (typesMasked.size() == 1) {
            string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor", typesMaskedString);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/TooBroadCatchInspection.buildErrorString must not return null");
            return string;
        }
        int lastTypeIndex = typesMasked.size() - 1;
        for (int i = 1; i < lastTypeIndex; ++i) {
            typesMaskedString = typesMaskedString + ", ";
            typesMaskedString = typesMaskedString + ((PsiType)typesMasked.get(i)).getPresentableText();
        }
        String lastTypeString = ((PsiType)typesMasked.get(lastTypeIndex)).getPresentableText();
        string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor1", typesMaskedString, lastTypeString);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/TooBroadCatchInspection.buildErrorString must not return null");
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        List maskedTypes = (List)infos[0];
        PsiTryStatement tryStatement = (PsiTryStatement)infos[1];
        PsiCatchSection catchSection = (PsiCatchSection)infos[2];
        ArrayList<AddCatchSectionFix> fixes = new ArrayList<AddCatchSectionFix>();
        for (PsiType thrown : maskedTypes) {
            fixes.add(new AddCatchSectionFix(tryStatement, thrown, catchSection));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/TooBroadCatchInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("too.broad.catch.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnRootExceptions");
    }

    private static TextRange getRangeToSelect(PsiCodeBlock block) {
        PsiElement first = block.getFirstBodyElement();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        if (first == null) {
            int offset = block.getTextRange().getStartOffset() + 1;
            return new TextRange(offset, offset);
        }
        PsiElement last = block.getLastBodyElement();
        if (last instanceof PsiWhiteSpace) {
            last = last.getPrevSibling();
        }
        TextRange textRange = last == null ? first.getTextRange() : last.getTextRange();
        return new TextRange(first.getTextRange().getStartOffset(), textRange.getEndOffset());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadCatchVisitor();
    }

    private class TooBroadCatchVisitor
    extends BaseInspectionVisitor {
        private TooBroadCatchVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/TooBroadCatchInspection$TooBroadCatchVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            PsiCodeBlock tryBlock = statement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Set<PsiType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
            int numExceptionsThrown = exceptionsThrown.size();
            HashSet<PsiType> exceptionsCaught = new HashSet<PsiType>(numExceptionsThrown);
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                String canonicalText;
                PsiParameter parameter = catchSection.getParameter();
                if (parameter == null) continue;
                PsiType typeCaught = parameter.getType();
                if (TooBroadCatchInspection.this.onlyWarnOnRootExceptions && !"java.lang.RuntimeException".equals(canonicalText = typeCaught.getCanonicalText()) && !"java.lang.Exception".equals(canonicalText) && !"java.lang.Throwable".equals(canonicalText)) continue;
                if (exceptionsThrown.contains(typeCaught)) {
                    exceptionsCaught.add(typeCaught);
                }
                ArrayList<PsiType> typesMasked = new ArrayList<PsiType>();
                for (PsiType typeThrown : exceptionsThrown) {
                    if (exceptionsCaught.contains(typeThrown) || !typeCaught.isAssignableFrom(typeThrown)) continue;
                    exceptionsCaught.add(typeCaught);
                    typesMasked.add(typeThrown);
                }
                if (typesMasked.isEmpty()) continue;
                PsiTypeElement typeElement = parameter.getTypeElement();
                this.registerError((PsiElement)typeElement, typesMasked, statement, catchSection);
            }
        }
    }

    private static class AddCatchSectionFix
    extends InspectionGadgetsFix {
        private final PsiTryStatement myTryStatement;
        private final PsiType myThrown;
        private final PsiCatchSection myBeforeCatchSection;

        AddCatchSectionFix(PsiTryStatement tryStatement, PsiType thrown, PsiCatchSection catchSection) {
            this.myTryStatement = tryStatement;
            this.myThrown = thrown;
            this.myBeforeCatchSection = catchSection;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String name = codeStyleManager.suggestUniqueVariableName("e", (PsiElement)this.myTryStatement.getTryBlock(), false);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiCatchSection section = factory.createCatchSection((PsiClassType)this.myThrown, name, (PsiElement)this.myTryStatement);
            PsiCatchSection element = (PsiCatchSection)this.myTryStatement.addBefore((PsiElement)section, (PsiElement)this.myBeforeCatchSection);
            codeStyleManager.shortenClassReferences((PsiElement)element);
            if (this.isOnTheFly()) {
                TextRange range = TooBroadCatchInspection.getRangeToSelect(element.getCatchBlock());
                PsiFile file = element.getContainingFile();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor == null) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                if (editor.getDocument() != document) {
                    return;
                }
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.catch.quickfix", this.myThrown.getPresentableText());
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/TooBroadCatchInspection$AddCatchSectionFix.getName must not return null");
            }
            return string;
        }
    }
}

