/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class EmptyFinallyBlockInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.finally.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Integer count = (Integer)infos[0];
        if (count == 0) {
            return new RemoveTryFinallyBlockFix();
        }
        return new RemoveFinallyBlockFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyFinallyBlockVisitor();
    }

    private static class EmptyFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyFinallyBlockVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiElement[] children;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$EmptyFinallyBlockVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiCodeBlock finallyBlock = statement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (finallyBlock.getStatements().length != 0) {
                return;
            }
            PsiCodeBlock[] catchBlocks = statement.getCatchBlocks();
            for (PsiElement child : children = statement.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                this.registerError(child, catchBlocks.length);
                return;
            }
        }
    }

    private static class RemoveFinallyBlockFix
    extends InspectionGadgetsFix {
        private RemoveFinallyBlockFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("remove.finally.block.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$RemoveFinallyBlockFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
            if (tryStatement == null) {
                return;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            RemoveFinallyBlockFix.deleteUntilFinally((PsiElement)finallyBlock);
        }

        private static void deleteUntilFinally(PsiElement element) {
            PsiJavaToken keyword;
            IElementType tokenType;
            if (element instanceof PsiJavaToken && (tokenType = (keyword = (PsiJavaToken)element).getTokenType()).equals(JavaTokenType.FINALLY_KEYWORD)) {
                keyword.delete();
                return;
            }
            RemoveFinallyBlockFix.deleteUntilFinally(element.getPrevSibling());
            if (!(element instanceof PsiWhiteSpace)) {
                element.delete();
            }
        }
    }

    private static class RemoveTryFinallyBlockFix
    extends InspectionGadgetsFix {
        private RemoveTryFinallyBlockFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("remove.try.finally.block.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$RemoveTryFinallyBlockFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
            if (tryStatement == null) {
                return;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiStatement[] statements = tryBlock.getStatements();
            PsiElement parent = tryStatement.getParent();
            for (PsiStatement statement : statements) {
                parent.addBefore((PsiElement)statement, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }
}

