/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NegatedIfElseInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;

    @NotNull
    public String getID() {
        if ("IfStatementWithNegatedCondition" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/NegatedIfElseInspection.getID must not return null");
        }
        return "IfStatementWithNegatedCondition";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.if.else.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/NegatedIfElseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.if.else.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/NegatedIfElseInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedIfElseVisitor();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("negated.if.else.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreNegatedNullComparison");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedIfElseFix();
    }

    private class NegatedIfElseVisitor
    extends BaseInspectionVisitor {
        private NegatedIfElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            if (!ExpressionUtils.isNegation(condition, NegatedIfElseInspection.this.m_ignoreNegatedNullComparison)) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }

    private static class NegatedIfElseFix
    extends InspectionGadgetsFix {
        private NegatedIfElseFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("negated.if.else.invert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiComment comment;
            IElementType tokenType;
            PsiElement ifToken = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifToken.getParent();
            assert (ifStatement != null);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            String elseText = elseBranch.getText();
            PsiElement lastChild = elseBranch.getLastChild();
            if (lastChild instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType = (comment = (PsiComment)lastChild).getTokenType())) {
                elseText = elseText + '\n';
            }
            String newStatement = "if(" + negatedCondition + ')' + elseText + " else " + thenBranch.getText();
            NegatedIfElseFix.replaceStatement((PsiStatement)ifStatement, newStatement);
        }
    }
}

