/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedXPathInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> xpathMethodNames = new HashSet<String>(2);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.xpath.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedXPathInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("malformed.xpath.expression.problem.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/MalformedXPathInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedXPathVisitor();
    }

    static {
        xpathMethodNames.add("compile");
        xpathMethodNames.add("evaluate");
    }

    private static class MalformedXPathVisitor
    extends BaseInspectionVisitor {
        private MalformedXPathVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/MalformedXPathInspection$MalformedXPathVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression xpathArgument = arguments[0];
            if (!TypeUtils.expressionHasType("java.lang.String", xpathArgument)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)xpathArgument)) {
                return;
            }
            PsiType type = xpathArgument.getType();
            String value = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)xpathArgument, (PsiType)type);
            if (value == null) {
                return;
            }
            if (!MalformedXPathVisitor.callTakesXPathExpression(expression)) {
                return;
            }
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            try {
                xpath.compile(value);
            }
            catch (XPathExpressionException ignore) {
                this.registerError((PsiElement)xpathArgument, new Object[0]);
            }
        }

        private static boolean callTakesXPathExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!xpathMethodNames.contains(name)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            return "javax.xml.xpath.XPath".equals(className);
        }
    }
}

