/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.CollectionUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CollectionUpdateCalledVisitor
extends JavaRecursiveElementVisitor {
    @NonNls
    private static final Set<String> updateNames = new HashSet<String>(31);
    private boolean updated = false;
    private final PsiVariable variable;

    CollectionUpdateCalledVisitor(PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CollectionUpdateCalledVisitor.visitElement must not be null");
        }
        if (!this.updated) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CollectionUpdateCalledVisitor.visitMethodCallExpression must not be null");
        }
        super.visitMethodCallExpression(call);
        if (this.updated) {
            return;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!updateNames.contains(methodName)) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (CollectionUtils.isCollectionClassOrInterface(aClass)) {
                this.updated = true;
            }
        } else {
            this.checkQualifier(qualifier);
        }
    }

    private void checkQualifier(PsiExpression expression) {
        if (this.updated) {
            return;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.updated = true;
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            this.checkQualifier(parenthesizedExpression.getExpression());
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            this.checkQualifier(thenExpression);
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            this.checkQualifier(elseExpression);
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    static {
        updateNames.add("add");
        updateNames.add("addAll");
        updateNames.add("addAllAbsent");
        updateNames.add("addBefore");
        updateNames.add("addElement");
        updateNames.add("addFirst");
        updateNames.add("addIfAbsent");
        updateNames.add("addLast");
        updateNames.add("clear");
        updateNames.add("drainTo");
        updateNames.add("insertElementAt");
        updateNames.add("load");
        updateNames.add("loadFromXML");
        updateNames.add("offer");
        updateNames.add("push");
        updateNames.add("put");
        updateNames.add("putAll");
        updateNames.add("putIfAbsent");
        updateNames.add("remove");
        updateNames.add("removeAll");
        updateNames.add("removeAllElements");
        updateNames.add("replace");
        updateNames.add("retainAll");
        updateNames.add("removeElementAt");
        updateNames.add("removeFirst");
        updateNames.add("removeLast");
        updateNames.add("removeRange");
        updateNames.add("set");
        updateNames.add("setElementAt");
        updateNames.add("setProperty");
        updateNames.add("take");
    }
}

