/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.DocumentAdapter;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.InspectionRunListener;
import com.siyeh.ig.ui.FormattedTextFieldMacFix;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.siyeh.ig.BaseInspection");
    private InspectionRunListener listener = null;
    @NonNls
    private static final String INSPECTION_GADGETS_COMPONENT_NAME = "InspectionGadgets";
    @NonNls
    private static final String INSPECTION = "Inspection";
    @NonNls
    private static final Map<String, String> packageGroupDisplayNameMap = new HashMap<String, String>();
    private String m_shortName = null;
    private long timeStamp = -1L;

    @NotNull
    public final String getShortName() {
        if (this.m_shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getName();
            assert (name.endsWith(INSPECTION)) : "class name must end with 'Inspection' to correctly calculate the short name: " + name;
            this.m_shortName = name.substring(name.lastIndexOf(46) + 1, name.length() - INSPECTION.length());
        }
        String string = this.m_shortName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspection.getShortName must not return null");
        }
        return string;
    }

    @Nls
    @NotNull
    public final String getGroupDisplayName() {
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        Package thisPackage = thisClass.getPackage();
        assert (thisPackage != null) : "need package to determine group display name";
        String name = thisPackage.getName();
        assert (name != null) : "inspection has default package, group display name cannot be determined";
        int index = name.lastIndexOf(46);
        String key = name.substring(index + 1);
        String groupDisplayName = packageGroupDisplayNameMap.get(key);
        assert (groupDisplayName != null) : "No display name found for " + key;
        String string = groupDisplayName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    protected abstract String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return null;
    }

    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspection.buildFixes must not return null");
        }
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    public boolean hasQuickFix() {
        Method[] methods;
        Class<?> aClass = ((Object)((Object)this)).getClass();
        for (Method method : methods = aClass.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!"buildFix".equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public abstract BaseInspectionVisitor buildVisitor();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/BaseInspection.buildVisitor must not be null");
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(holder);
        visitor.setOnTheFly(isOnTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/BaseInspection.buildVisitor must not return null");
        }
        return baseInspectionVisitor;
    }

    protected JFormattedTextField prepareNumberEditor(@NonNls String fieldName) {
        try {
            NumberFormat formatter = NumberFormat.getIntegerInstance();
            formatter.setParseIntegerOnly(true);
            final JFormattedTextField valueField = new JFormattedTextField(formatter);
            final Field field = ((Object)((Object)this)).getClass().getField(fieldName);
            valueField.setValue(field.get((Object)this));
            valueField.setColumns(4);
            FormattedTextFieldMacFix.apply(valueField);
            Document document = valueField.getDocument();
            document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent evt) {
                    try {
                        valueField.commitEdit();
                        field.set((Object)BaseInspection.this, ((Number)valueField.getValue()).intValue());
                    }
                    catch (IllegalAccessException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            });
            return valueField;
        }
        catch (NoSuchFieldException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    protected static void parseString(String string, List<String> ... outs) {
        List strings = StringUtil.split((String)string, (String)",");
        for (List<String> out : outs) {
            out.clear();
        }
        int iMax = strings.size();
        for (int i = 0; i < iMax; i += outs.length) {
            for (int j = 0; j < outs.length; ++j) {
                List<String> out;
                out = outs[j];
                if (i + j >= iMax) {
                    out.add("");
                    continue;
                }
                out.add((String)strings.get(i + j));
            }
        }
    }

    protected static String formatString(List<String> ... strings) {
        StringBuilder buffer = new StringBuilder();
        int size = strings[0].size();
        if (size > 0) {
            BaseInspection.formatString(strings, 0, buffer);
            for (int i = 1; i < size; ++i) {
                buffer.append(',');
                BaseInspection.formatString(strings, i, buffer);
            }
        }
        return buffer.toString();
    }

    private static void formatString(List<String>[] strings, int index, StringBuilder out) {
        out.append(strings[0].get(index));
        for (int i = 1; i < strings.length; ++i) {
            out.append(',');
            out.append(strings[i].get(index));
        }
    }

    private void initializeTelemetryIfNecessary() {
    }

    public void inspectionStarted(LocalInspectionToolSession session) {
        super.inspectionStarted(session);
    }

    public void inspectionFinished(LocalInspectionToolSession session) {
        super.inspectionFinished(session);
    }

    static {
        packageGroupDisplayNameMap.put("abstraction", GroupNames.ABSTRACTION_GROUP_NAME);
        packageGroupDisplayNameMap.put("assignment", GroupNames.ASSIGNMENT_GROUP_NAME);
        packageGroupDisplayNameMap.put("bitwise", GroupNames.BITWISE_GROUP_NAME);
        packageGroupDisplayNameMap.put("bugs", GroupNames.BUGS_GROUP_NAME);
        packageGroupDisplayNameMap.put("classlayout", GroupNames.CLASSLAYOUT_GROUP_NAME);
        packageGroupDisplayNameMap.put("classmetrics", GroupNames.CLASSMETRICS_GROUP_NAME);
        packageGroupDisplayNameMap.put("cloneable", GroupNames.CLONEABLE_GROUP_NAME);
        packageGroupDisplayNameMap.put("controlflow", GroupNames.CONTROL_FLOW_GROUP_NAME);
        packageGroupDisplayNameMap.put("dataflow", GroupNames.DATA_FLOW_ISSUES);
        packageGroupDisplayNameMap.put("dependency", GroupNames.DEPENDENCY_GROUP_NAME);
        packageGroupDisplayNameMap.put("encapsulation", GroupNames.ENCAPSULATION_GROUP_NAME);
        packageGroupDisplayNameMap.put("errorhandling", GroupNames.ERRORHANDLING_GROUP_NAME);
        packageGroupDisplayNameMap.put("finalization", GroupNames.FINALIZATION_GROUP_NAME);
        packageGroupDisplayNameMap.put("imports", GroupNames.IMPORTS_GROUP_NAME);
        packageGroupDisplayNameMap.put("inheritance", GroupNames.INHERITANCE_GROUP_NAME);
        packageGroupDisplayNameMap.put("initialization", GroupNames.INITIALIZATION_GROUP_NAME);
        packageGroupDisplayNameMap.put("internationalization", GroupNames.INTERNATIONALIZATION_GROUP_NAME);
        packageGroupDisplayNameMap.put("j2me", GroupNames.J2ME_GROUP_NAME);
        packageGroupDisplayNameMap.put("javabeans", GroupNames.JAVABEANS_GROUP_NAME);
        packageGroupDisplayNameMap.put("jdk", GroupNames.JDK_GROUP_NAME);
        packageGroupDisplayNameMap.put("jdk15", GroupNames.JDK15_SPECIFIC_GROUP_NAME);
        packageGroupDisplayNameMap.put("junit", GroupNames.JUNIT_GROUP_NAME);
        packageGroupDisplayNameMap.put("logging", GroupNames.LOGGING_GROUP_NAME);
        packageGroupDisplayNameMap.put("maturity", GroupNames.MATURITY_GROUP_NAME);
        packageGroupDisplayNameMap.put("memory", GroupNames.MEMORY_GROUP_NAME);
        packageGroupDisplayNameMap.put("methodmetrics", GroupNames.METHODMETRICS_GROUP_NAME);
        packageGroupDisplayNameMap.put("modularization", GroupNames.MODULARIZATION_GROUP_NAME);
        packageGroupDisplayNameMap.put("naming", GroupNames.NAMING_CONVENTIONS_GROUP_NAME);
        packageGroupDisplayNameMap.put("numeric", GroupNames.NUMERIC_GROUP_NAME);
        packageGroupDisplayNameMap.put("packaging", GroupNames.PACKAGING_GROUP_NAME);
        packageGroupDisplayNameMap.put("performance", GroupNames.PERFORMANCE_GROUP_NAME);
        packageGroupDisplayNameMap.put("portability", GroupNames.PORTABILITY_GROUP_NAME);
        packageGroupDisplayNameMap.put("resources", GroupNames.RESOURCE_GROUP_NAME);
        packageGroupDisplayNameMap.put("security", GroupNames.SECURITY_GROUP_NAME);
        packageGroupDisplayNameMap.put("serialization", GroupNames.SERIALIZATION_GROUP_NAME);
        packageGroupDisplayNameMap.put("style", GroupNames.STYLE_GROUP_NAME);
        packageGroupDisplayNameMap.put("threading", GroupNames.THREADING_GROUP_NAME);
        packageGroupDisplayNameMap.put("visibility", GroupNames.VISIBILITY_GROUP_NAME);
    }
}

