/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

final class MessageNode
extends DefaultMutableTreeNode {
    private String[] myText;
    private AntMessage myMessage;
    private RangeMarker myRangeMarker;
    private Document myEditorDocument;
    private boolean myAllowToShowPosition;

    public MessageNode(final AntMessage message, final Project project, final boolean allowToShowPosition) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile;
                MessageNode.this.myMessage = message;
                MessageNode.access$102(MessageNode.this, message.getTextLines());
                if (MessageNode.this.myMessage.getFile() != null && (psiFile = PsiManager.getInstance((Project)project).findFile(MessageNode.this.myMessage.getFile())) != null) {
                    MessageNode.this.myEditorDocument = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (MessageNode.this.myEditorDocument != null) {
                        int start;
                        int line = MessageNode.this.myMessage.getLine();
                        int column = MessageNode.this.myMessage.getColumn();
                        if (line - 1 >= 0 && line < MessageNode.this.myEditorDocument.getLineCount() && (start = MessageNode.this.myEditorDocument.getLineStartOffset(line - 1) + column - 1) >= 0 && start < MessageNode.this.myEditorDocument.getTextLength()) {
                            MessageNode.this.myRangeMarker = MessageNode.this.myEditorDocument.createRangeMarker(start, start);
                        }
                    }
                }
                MessageNode.this.myAllowToShowPosition = allowToShowPosition;
            }
        });
    }

    public String[] getText() {
        return this.myText;
    }

    public VirtualFile getFile() {
        return this.myMessage.getFile();
    }

    public int getOffset() {
        if (this.myRangeMarker == null) {
            return -1;
        }
        return this.myRangeMarker.getStartOffset();
    }

    public AntBuildMessageView.MessageType getType() {
        return this.myMessage.getType();
    }

    public String getPositionString() {
        if (this.myRangeMarker == null || !this.myAllowToShowPosition) {
            return "";
        }
        return "(" + this.myMessage.getLine() + ", " + this.myMessage.getColumn() + ") ";
    }

    @Nullable
    public String getTypeString() {
        AntBuildMessageView.MessageType type = this.myMessage.getType();
        if (type == AntBuildMessageView.MessageType.BUILD) {
            return AntBundle.message("ant.build.message.node.prefix.text", new Object[0]);
        }
        if (type == AntBuildMessageView.MessageType.TARGET) {
            return AntBundle.message("ant.target.message.node.prefix.text", new Object[0]);
        }
        if (type == AntBuildMessageView.MessageType.TASK) {
            return AntBundle.message("ant.task.message.node.prefix.text", new Object[0]);
        }
        return "";
    }

    public int getPriority() {
        return this.myMessage.getPriority();
    }

    static /* synthetic */ String[] access$102(MessageNode x0, String[] x1) {
        x0.myText = x1;
        return x1;
    }
}

