/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsResultEx;
import com.intellij.cvsSupport2.config.AbstractConfiguration;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.config.ExtConfiguration;
import com.intellij.cvsSupport2.config.LocalSettings;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.connections.IDEARootFormatter;
import com.intellij.cvsSupport2.connections.SelfTestingConnection;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetModulesListOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorMessagesProcessor;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.openapi.cvsIntegration.CvsRepository;
import com.intellij.openapi.cvsIntegration.DateOrRevision;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsException;
import java.io.IOException;
import java.util.List;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.ValidRequestsExpectedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.util.BugLog;

public class CvsRootConfiguration
extends AbstractConfiguration
implements CvsEnvironment,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.config.CvsRootConfiguration");
    public String CVS_ROOT = "";
    public String PATH_TO_WORKING_FOLDER = "";
    public ProxySettings PROXY_SETTINGS = new ProxySettings();
    public ExtConfiguration EXT_CONFIGURATION = new ExtConfiguration();
    public SshSettings SSH_CONFIGURATION = new SshSettings();
    public SshSettings SSH_FOR_EXT_CONFIGURATION = new SshSettings();
    public LocalSettings LOCAL_CONFIGURATION = new LocalSettings();
    public DateOrRevisionSettings DATE_OR_REVISION_SETTINGS = new DateOrRevisionSettings();
    private static final String SEPARATOR = ":";
    private static final String AT = "@";

    public CvsRootConfiguration() {
        super("CvsRootConfiguration");
    }

    private CvsConnectionSettings getSettings() {
        return this.createSettings();
    }

    public CvsConnectionSettings createSettings() {
        return new IDEARootFormatter(this).createConfiguration();
    }

    public IConnection createConnection(ReadWriteStatistics statistics) {
        return this.getSettings().createConnection(statistics);
    }

    public String getCvsRootAsString() {
        return this.CVS_ROOT;
    }

    private static String createFieldByFieldCvsRoot(CvsRepository cvsRepository) {
        return CvsRootConfiguration.createStringRepresentationOn(CvsMethod.getValue((String)cvsRepository.getMethod()), cvsRepository.getUser(), cvsRepository.getHost(), String.valueOf(cvsRepository.getPort()), cvsRepository.getRepository());
    }

    public static String createStringRepresentationOn(CvsMethod method, String user, String host, String port, String repository) {
        StringBuffer result = new StringBuffer();
        if (method == CvsMethod.LOCAL_METHOD) {
            return repository;
        }
        result.append(SEPARATOR);
        result.append(method.getName());
        result.append(SEPARATOR);
        result.append(user);
        result.append(AT);
        result.append(host);
        if (port.length() > 0) {
            result.append(SEPARATOR);
            result.append(port);
        } else {
            result.append(SEPARATOR);
        }
        result.append(repository);
        return result.toString();
    }

    public String toString() {
        if (this.useBranch()) {
            return CvsBundle.message((String)"cvs.root.configuration.on.branch.string.representation", (Object[])new Object[]{this.getCvsRootAsString(), this.DATE_OR_REVISION_SETTINGS.BRANCH});
        }
        if (this.useDate()) {
            return CvsBundle.message((String)"cvs.root.configuration.on.date.string.representation", (Object[])new Object[]{this.getCvsRootAsString(), this.DATE_OR_REVISION_SETTINGS.getDate()});
        }
        return this.getCvsRootAsString();
    }

    private boolean useDate() {
        return this.DATE_OR_REVISION_SETTINGS.USE_DATE && this.DATE_OR_REVISION_SETTINGS.getDate().length() > 0;
    }

    private boolean useBranch() {
        return this.DATE_OR_REVISION_SETTINGS.USE_BRANCH && this.DATE_OR_REVISION_SETTINGS.BRANCH.length() > 0;
    }

    public CvsRootConfiguration getMyCopy() {
        try {
            return (CvsRootConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void testConnection() throws Exception {
        CvsRootConfiguration.testConnection(this.getSettings().createConnection(new ReadWriteStatistics()), this.getSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testConnection(final IConnection connection, final CvsConnectionSettings settings) throws AuthenticationException, IOException {
        ErrorMessagesProcessor errorProcessor = new ErrorMessagesProcessor();
        final CvsExecutionEnvironment cvsExecutionEnvironment = new CvsExecutionEnvironment(errorProcessor, CvsExecutionEnvironment.DUMMY_STOPPER, errorProcessor, new ModalityContextImpl(true), PostCvsActivity.DEAF);
        final CvsResultEx result = new CvsResultEx();
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    GetModulesListOperation operation = new GetModulesListOperation(settings);
                    CvsRootProvider cvsRootProvider = operation.getCvsRootProvider();
                    try {
                        if (connection instanceof SelfTestingConnection) {
                            ((SelfTestingConnection)connection).test(CvsListenerWithProgress.createOnProgress());
                        }
                        operation.execute(cvsRootProvider, cvsExecutionEnvironment, connection);
                    }
                    catch (ValidRequestsExpectedException ex) {
                        result.addError(new CvsException(ex, cvsRootProvider.getCvsRootAsString()));
                    }
                    catch (CommandException ex) {
                        result.addError(new CvsException(ex.getUnderlyingException(), cvsRootProvider.getCvsRootAsString()));
                    }
                    catch (ProcessCanceledException ex) {
                        result.setIsCanceled();
                    }
                    catch (BugLog.BugException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (Exception e) {
                        result.addError(new CvsException(e, cvsRootProvider.getCvsRootAsString()));
                    }
                }
            }, CvsBundle.message((String)"operation.name.test.connection", (Object[])new Object[0]), true, null);
            if (result.isCanceled()) {
                throw new ProcessCanceledException();
            }
            if (!result.hasNoErrors()) {
                VcsException vcsException = result.composeError();
                throw new AuthenticationException(vcsException.getLocalizedMessage(), vcsException.getCause());
            }
            List<VcsException> errors = errorProcessor.getErrors();
            if (!errors.isEmpty()) {
                VcsException firstError = errors.get(0);
                throw new AuthenticationException(firstError.getLocalizedMessage(), (Throwable)firstError);
            }
        }
        finally {
            connection.close();
        }
    }

    public int hashCode() {
        return this.CVS_ROOT.hashCode() ^ this.DATE_OR_REVISION_SETTINGS.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CvsRootConfiguration)) {
            return false;
        }
        CvsRootConfiguration another = (CvsRootConfiguration)obj;
        return this.CVS_ROOT.equals(another.CVS_ROOT) && this.DATE_OR_REVISION_SETTINGS.equals((Object)another.DATE_OR_REVISION_SETTINGS) && Comparing.equal((Object)this.EXT_CONFIGURATION, (Object)another.EXT_CONFIGURATION);
    }

    public CvsLoginWorker getLoginWorker(ModalityContext executor, Project project) {
        return this.getSettings().getLoginWorker(executor, project);
    }

    public RevisionOrDate getRevisionOrDate() {
        return RevisionOrDateImpl.createOn(this.DATE_OR_REVISION_SETTINGS);
    }

    public String getRepository() {
        return this.getSettings().getRepository();
    }

    public CvsRoot getCvsRoot() {
        return this.getSettings().getCvsRoot();
    }

    public boolean isValid() {
        return this.getSettings().isValid();
    }

    public CvsRepository createCvsRepository() {
        CvsConnectionSettings settings = this.createSettings();
        return new CvsRepository(settings.getCvsRootAsString(), settings.METHOD.getName(), settings.USER, settings.HOST, settings.REPOSITORY, settings.PORT, (DateOrRevision)this.DATE_OR_REVISION_SETTINGS);
    }

    public static CvsRootConfiguration createOn(CvsRepository repository) {
        CvsRootConfiguration result = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
        result.DATE_OR_REVISION_SETTINGS.updateFrom(repository.getDateOrRevision());
        result.CVS_ROOT = CvsRootConfiguration.createFieldByFieldCvsRoot(repository);
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        CvsRootConfiguration result = (CvsRootConfiguration)super.clone();
        result.DATE_OR_REVISION_SETTINGS = (DateOrRevisionSettings)this.DATE_OR_REVISION_SETTINGS.clone();
        return result;
    }

    public CommandException processException(CommandException t) {
        return this.getSettings().processException(t);
    }

    public boolean isOffline() {
        return this.getSettings().isOffline();
    }
}

