/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;

public class FileFinder {
    public static List<VirtualFile> findPomFiles(VirtualFile[] roots, boolean lookForNested, ProgressIndicator indicator, List<VirtualFile> result) {
        for (VirtualFile f : roots) {
            if (indicator.isCanceled()) break;
            indicator.setText2(f.getPath());
            if (f.isDirectory()) {
                if (!lookForNested) continue;
                FileFinder.findPomFiles(f.getChildren(), lookForNested, indicator, result);
                continue;
            }
            if (!f.getName().equalsIgnoreCase("pom.xml")) continue;
            result.add(f);
        }
        return result;
    }

    public static VirtualFile refreshRecursively(final String path) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                if (dir != null) {
                    dir.refresh(false, true);
                }
                return dir;
            }
        });
    }
}

