/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.idea.maven.utils.Path;

public class MavenRunnerParameters
implements Cloneable {
    private boolean isPomExecution;
    private Path myWorkingDirPath;
    private List<String> myGoals;
    private SortedSet<String> myProfiles;

    public MavenRunnerParameters() {
        this(true, "", null, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, String workingDirPath, List<String> goals, Collection<String> profiles) {
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setGoals(goals);
        this.setProfiles(profiles);
    }

    public MavenRunnerParameters(MavenRunnerParameters that) {
        this(that.isPomExecution, that.getWorkingDirPath(), that.myGoals, that.myProfiles);
    }

    public boolean isPomExecution() {
        return this.isPomExecution;
    }

    public String getWorkingDirPath() {
        return this.myWorkingDirPath.getPath();
    }

    public void setWorkingDirPath(String workingDirPath) {
        this.myWorkingDirPath = new Path(workingDirPath);
    }

    public File getWorkingDirFile() {
        return new File(this.myWorkingDirPath.getPath());
    }

    public String getPomFilePath() {
        if (!this.isPomExecution) {
            return null;
        }
        return new File(this.myWorkingDirPath.getPath(), "pom.xml").getPath();
    }

    public List<String> getGoals() {
        return this.myGoals;
    }

    public void setGoals(List<String> goals) {
        this.myGoals = new ArrayList<String>();
        if (goals != null) {
            this.myGoals.addAll(goals);
        }
    }

    public Collection<String> getProfiles() {
        return this.myProfiles;
    }

    public void setProfiles(Collection<String> profiles) {
        this.myProfiles = new TreeSet<String>();
        if (profiles != null) {
            this.myProfiles.addAll(profiles);
        }
    }

    public MavenRunnerParameters clone() {
        return new MavenRunnerParameters(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerParameters that = (MavenRunnerParameters)o;
        if (this.isPomExecution != that.isPomExecution) {
            return false;
        }
        if (this.myGoals != null ? !((Object)this.myGoals).equals(that.myGoals) : that.myGoals != null) {
            return false;
        }
        if (this.myWorkingDirPath != null ? !this.myWorkingDirPath.equals(that.myWorkingDirPath) : that.myWorkingDirPath != null) {
            return false;
        }
        return !(this.myProfiles != null ? !this.myProfiles.equals(that.myProfiles) : that.myProfiles != null);
    }

    public int hashCode() {
        int result = this.isPomExecution ? 1 : 0;
        result = 31 * result + (this.myWorkingDirPath != null ? this.myWorkingDirPath.hashCode() : 0);
        result = 31 * result + (this.myGoals != null ? ((Object)this.myGoals).hashCode() : 0);
        result = 31 * result + (this.myProfiles != null ? this.myProfiles.hashCode() : 0);
        return result;
    }
}

