/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyScriptRunner
extends GroovyScriptRunner {
    @Override
    public boolean isValidModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/runner/DefaultGroovyScriptRunner.isValidModule must not be null");
        }
        return LibrariesUtil.hasGroovySdk(module);
    }

    @Override
    public boolean ensureRunnerConfigured(@Nullable Module module, String confName, Project project) throws ExecutionException {
        if (module == null) {
            throw new ExecutionException("Module is not specified");
        }
        if (LibrariesUtil.getGroovyHomePath(module) == null) {
            Messages.showErrorDialog((Project)module.getProject(), (String)ExecutionBundle.message((String)"error.running.configuration.with.error.error.message", (Object[])new Object[]{confName, "Groovy is not configured"}), (String)ExecutionBundle.message((String)"run.error.message.title", (Object[])new Object[0]));
            ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.NAME, (boolean)false);
            return false;
        }
        return true;
    }

    @Override
    public void configureCommandLine(JavaParameters params, @Nullable Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(params, module, tests, "groovy.ui.GroovyMain");
        DefaultGroovyScriptRunner.addClasspathFromRootModel(module, tests, params);
        params.getVMParametersList().addParametersString(configuration.vmParams);
        params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)configuration.scriptPath));
        params.getProgramParametersList().addParametersString(configuration.scriptParams);
        DefaultGroovyScriptRunner.addScriptEncodingSettings(params, script, module);
        if (configuration.isDebugEnabled) {
            params.getProgramParametersList().add("--debug");
        }
    }

    public static void configureGenericGroovyRunner(JavaParameters params, Module module, boolean tests, String mainClass) throws CantRunException {
        assert (module != null);
        VirtualFile groovyJar = DefaultGroovyScriptRunner.findGroovyJar(module);
        if (groovyJar != null) {
            params.getClassPath().add(groovyJar);
        }
        DefaultGroovyScriptRunner.setToolsJar(params);
        String groovyHome = FileUtil.toSystemDependentName((String)((String)ObjectUtils.assertNotNull((Object)LibrariesUtil.getGroovyHomePath(module))));
        DefaultGroovyScriptRunner.setGroovyHome(params, groovyHome);
        String confPath = DefaultGroovyScriptRunner.getConfPath(groovyHome);
        params.getVMParametersList().add("-Dgroovy.starter.conf=" + confPath);
        params.setMainClass("org.codehaus.groovy.tools.GroovyStarter");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confPath);
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add(mainClass);
    }

    private static void addScriptEncodingSettings(JavaParameters params, VirtualFile scriptFile, Module module) {
        Charset charset = EncodingProjectManager.getInstance((Project)module.getProject()).getEncoding(scriptFile, true);
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
            if (!Comparing.equal((Object)CharsetToolkit.getDefaultSystemCharset(), (Object)charset)) {
                params.getProgramParametersList().add("--encoding=" + charset.displayName());
            }
        } else {
            params.getProgramParametersList().add("--encoding=" + charset.displayName());
        }
    }
}

