/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyInlineVariableUtil {
    public static final String REFACTORING_NAME = GroovyRefactoringBundle.message("inline.variable.title", new Object[0]);

    private GroovyInlineVariableUtil() {
    }

    static InlineHandler.Inliner createInlinerForLocalVariable(final GrVariable variable) {
        return new InlineHandler.Inliner(){

            @Nullable
            public Map<PsiElement, String> getConflicts(PsiReference reference, PsiElement referenced) {
                GrAssignmentExpression parent;
                HashMap<PsiElement, String> conflicts = new HashMap<PsiElement, String>();
                GrExpression expr = (GrExpression)reference.getElement();
                if (expr.getParent() instanceof GrAssignmentExpression && expr.equals((parent = (GrAssignmentExpression)expr.getParent()).getLValue())) {
                    conflicts.put(expr, GroovyRefactoringBundle.message("local.varaible.is.lvalue", new Object[0]));
                }
                return conflicts;
            }

            public void inlineUsage(UsageInfo usage, PsiElement referenced) {
                GrExpression exprToBeReplaced = (GrExpression)usage.getElement();
                if (exprToBeReplaced == null) {
                    return;
                }
                assert (variable.getInitializerGroovy() != null);
                GrExpression initializerGroovy = variable.getInitializerGroovy();
                assert (initializerGroovy != null);
                GrExpression tempExpr = initializerGroovy;
                while (tempExpr instanceof GrParenthesizedExpression) {
                    tempExpr = ((GrParenthesizedExpression)tempExpr).getOperand();
                }
                Project project = variable.getProject();
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
                GrExpression newExpr = factory.createExpressionFromText(tempExpr.getText());
                newExpr = exprToBeReplaced.replaceWithExpression(newExpr, true);
                FileEditorManager manager = FileEditorManager.getInstance((Project)project);
                Editor editor = manager.getSelectedTextEditor();
                GroovyRefactoringUtil.highlightOccurrences(project, editor, new PsiElement[]{newExpr});
                WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
            }
        };
    }

    @Nullable
    static InlineHandler.Settings inlineLocalVariableSettings(GrVariable variable, Editor editor, boolean invokedOnReference) {
        String message;
        String localName = variable.getName();
        Project project = variable.getProject();
        Collection refs = ReferencesSearch.search((PsiElement)variable).findAll();
        ArrayList<PsiElement> exprs = new ArrayList<PsiElement>();
        for (PsiReference ref : refs) {
            exprs.add(ref.getElement());
        }
        GroovyRefactoringUtil.highlightOccurrences(project, editor, exprs.toArray(new PsiElement[exprs.size()]));
        if (variable.getInitializerGroovy() == null) {
            message = GroovyRefactoringBundle.message("cannot.find.a.single.definition.to.inline.local.var", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)variable.getProject(), (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return null;
        }
        if (refs.isEmpty()) {
            message = GroovyRefactoringBundle.message("variable.is.never.used.0", variable.getName());
            CommonRefactoringUtil.showErrorHint((Project)variable.getProject(), (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineVariable");
            return null;
        }
        return GroovyInlineVariableUtil.inlineDialogResult(localName, project, refs);
    }

    @Nullable
    private static InlineHandler.Settings inlineDialogResult(String localName, Project project, Collection<PsiReference> refs) {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            String question = GroovyRefactoringBundle.message("inline.local.variable.prompt.0.1", localName, refs.size());
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(REFACTORING_NAME, question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
            dialog.show();
            if (!dialog.isOK()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
                return null;
            }
        }
        return new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return false;
            }
        };
    }
}

