/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyImportOptimizerRefactoringHelper
implements RefactoringHelper<Set<GroovyFile>> {
    public Set<GroovyFile> prepareOperation(UsageInfo[] usages) {
        HashSet files = new HashSet();
        for (UsageInfo usage : usages) {
            PsiFile file;
            PsiElement element = usage.getElement();
            if (element == null || !((file = element.getContainingFile()) instanceof GroovyFile)) continue;
            files.add((GroovyFile)file);
        }
        return files;
    }

    public void performOperation(Project project, Set<GroovyFile> files) {
        GroovyImportOptimizer optimizer = new GroovyImportOptimizer();
        for (GroovyFile file : files) {
            optimizer.removeUnusedImports(file);
        }
    }
}

