/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrClassSubstitutor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;

public class GroovyResolveResultImpl
implements GroovyResolveResult {
    private PsiElement myElement;
    private boolean myIsAccessible;
    private boolean myIsStaticsOK;
    private PsiSubstitutor mySubstitutor;
    private GroovyPsiElement myCurrentFileResolveContext;

    public GroovyResolveResultImpl(PsiElement element, boolean isAccessible) {
        this(element, null, PsiSubstitutor.EMPTY, isAccessible, true);
    }

    public GroovyResolveResultImpl(PsiElement element, GroovyPsiElement context, PsiSubstitutor substitutor, boolean isAccessible, boolean staticsOK) {
        this.myCurrentFileResolveContext = context;
        this.myElement = element instanceof PsiClass ? GrClassSubstitutor.getSubstitutedClass((PsiClass)element) : element;
        this.myIsAccessible = isAccessible;
        this.mySubstitutor = substitutor;
        this.myIsStaticsOK = staticsOK;
    }

    @Override
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @Override
    public boolean isAccessible() {
        return this.myIsAccessible;
    }

    @Override
    public boolean isStaticsOK() {
        return this.myIsStaticsOK;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean isValidResult() {
        return this.isAccessible();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroovyResolveResultImpl that = (GroovyResolveResultImpl)o;
        return this.myIsAccessible == that.myIsAccessible && this.myElement.getManager().areElementsEquivalent(this.myElement, that.myElement);
    }

    public int hashCode() {
        String name;
        int result = 0;
        if (this.myElement instanceof PsiNamedElement && (name = ((PsiNamedElement)this.myElement).getName()) != null) {
            result = name.hashCode();
        }
        result = 31 * result + (this.myIsAccessible ? 1 : 0);
        return result;
    }

    @Override
    public GroovyPsiElement getCurrentFileResolveContext() {
        return this.myCurrentFileResolveContext;
    }
}

