/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class TypesSemilattice
implements Semilattice<Map<String, PsiType>> {
    PsiManager myManager;

    public TypesSemilattice(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    public Map<String, PsiType> join(ArrayList<Map<String, PsiType>> ins) {
        if (ins.size() == 0) {
            return new HashMap();
        }
        HashMap result = new HashMap(ins.get(0));
        for (int i = 1; i < ins.size(); ++i) {
            Map<String, PsiType> map = ins.get(i);
            for (Map.Entry<String, PsiType> entry : map.entrySet()) {
                String name = entry.getKey();
                PsiType t1 = entry.getValue();
                if (!result.containsKey(name)) continue;
                PsiType t2 = (PsiType)result.get(name);
                if (t1 != null && t2 != null) {
                    result.put(name, TypesUtil.getLeastUpperBound(t1, t2, this.myManager));
                    continue;
                }
                result.put(name, null);
            }
        }
        return result;
    }

    @Override
    public boolean eq(Map<String, PsiType> e1, Map<String, PsiType> e2) {
        if (e1.size() != e2.size()) {
            return false;
        }
        for (Map.Entry<String, PsiType> entry : e1.entrySet()) {
            String name = entry.getKey();
            if (!e2.containsKey(name)) {
                return false;
            }
            PsiType t1 = entry.getValue();
            PsiType t2 = e2.get(name);
            if (!(t1 == null || t2 == null ? t1 != null || t2 != null : !t1.equals(t2))) continue;
            return false;
        }
        return true;
    }
}

