/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;

public class ReachingDefinitionsDfaInstance
implements DfaInstance<TIntObjectHashMap<TIntHashSet>> {
    private final TObjectIntHashMap<String> myVarToIndexMap = new TObjectIntHashMap();

    public int getVarIndex(String varName) {
        return this.myVarToIndexMap.get((Object)varName);
    }

    public ReachingDefinitionsDfaInstance(Instruction[] flow) {
        int num = 0;
        for (Instruction instruction : flow) {
            String name;
            if (!(instruction instanceof ReadWriteVariableInstruction) || this.myVarToIndexMap.containsKey((Object)(name = ((ReadWriteVariableInstruction)instruction).getVariableName()))) continue;
            this.myVarToIndexMap.put((Object)name, num++);
        }
    }

    @Override
    public void fun(TIntObjectHashMap<TIntHashSet> m, Instruction instruction) {
        if (instruction instanceof ReadWriteVariableInstruction) {
            ReadWriteVariableInstruction varInsn = (ReadWriteVariableInstruction)instruction;
            String name = varInsn.getVariableName();
            assert (this.myVarToIndexMap.containsKey((Object)name));
            int num = this.myVarToIndexMap.get((Object)name);
            if (varInsn.isWrite()) {
                TIntHashSet defs = (TIntHashSet)m.get(num);
                if (defs == null) {
                    defs = new TIntHashSet();
                    m.put(num, (Object)defs);
                } else {
                    defs.clear();
                }
                defs.add(varInsn.num());
            }
        }
    }

    @Override
    @NotNull
    public TIntObjectHashMap<TIntHashSet> initial() {
        TIntObjectHashMap tIntObjectHashMap = new TIntObjectHashMap();
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsDfaInstance.initial must not return null");
        }
        return tIntObjectHashMap;
    }

    @Override
    public boolean isForward() {
        return true;
    }
}

