/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public class InstructionImpl
implements Instruction,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl");
    ArrayList<InstructionImpl> myPred = new ArrayList();
    ArrayList<InstructionImpl> mySucc = new ArrayList();
    PsiElement myPsiElement;
    private final int myNumber;

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    public InstructionImpl(PsiElement element, int num) {
        this.myPsiElement = element;
        this.myNumber = num;
    }

    protected Stack<CallInstruction> getStack(CallEnvironment env, InstructionImpl instruction) {
        return env.callStack(instruction);
    }

    @Override
    public Iterable<? extends Instruction> succ(CallEnvironment env) {
        Stack<CallInstruction> stack = this.getStack(env, this);
        for (InstructionImpl instruction : this.mySucc) {
            env.update(stack, instruction);
        }
        return this.mySucc;
    }

    @Override
    public Iterable<? extends Instruction> pred(CallEnvironment env) {
        Stack<CallInstruction> stack = this.getStack(env, this);
        for (InstructionImpl instruction : this.myPred) {
            env.update(stack, instruction);
        }
        return this.myPred;
    }

    @Override
    public Iterable<? extends Instruction> allSucc() {
        return this.mySucc;
    }

    @Override
    public Iterable<? extends Instruction> allPred() {
        return this.myPred;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (int i = 0; i < this.mySucc.size(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.mySucc.get((int)i).myNumber);
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    protected String getElementPresentation() {
        return "element: " + this.myPsiElement;
    }

    @Override
    public int num() {
        return this.myNumber;
    }
}

