/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.types;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TypeSpec
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder) {
        return TypeSpec.parse(builder, false);
    }

    public static boolean parse(PsiBuilder builder, boolean isUpper) {
        if (TokenSets.BUILT_IN_TYPE.contains(builder.getTokenType())) {
            return TypeSpec.parseBuiltInType(builder);
        }
        if (builder.getTokenType() == mIDENT) {
            return TypeSpec.parseClassOrInterfaceType(builder, isUpper);
        }
        return false;
    }

    public static boolean parseBuiltInType(PsiBuilder builder) {
        PsiBuilder.Marker arrMarker = builder.mark();
        ParserUtils.eatElement(builder, BUILT_IN_TYPE);
        if (mLBRACK.equals(builder.getTokenType())) {
            TypeSpec.declarationBracketsParse(builder, arrMarker);
        } else {
            arrMarker.drop();
        }
        return true;
    }

    private static void declarationBracketsParse(PsiBuilder builder, PsiBuilder.Marker marker) {
        ParserUtils.getToken(builder, mLBRACK);
        ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)ARRAY_TYPE);
        if (mLBRACK.equals(builder.getTokenType())) {
            TypeSpec.declarationBracketsParse(builder, newMarker);
        } else {
            newMarker.drop();
        }
    }

    private static boolean parseClassOrInterfaceType(PsiBuilder builder, boolean isUpper) {
        PsiBuilder.Marker arrMarker = builder.mark();
        PsiBuilder.Marker typeElementMarker = builder.mark();
        if (!ReferenceElement.parseReferenceElement(builder, isUpper)) {
            typeElementMarker.drop();
            arrMarker.rollbackTo();
            return false;
        }
        typeElementMarker.done((IElementType)CLASS_TYPE_ELEMENT);
        if (ParserUtils.lookAhead(builder, mLBRACK, mRBRACK)) {
            TypeSpec.declarationBracketsParse(builder, arrMarker);
        } else {
            arrMarker.drop();
        }
        return true;
    }

    public static boolean parseStrict(PsiBuilder builder) {
        if (TokenSets.BUILT_IN_TYPE.contains(builder.getTokenType())) {
            return TypeSpec.parseBuiltInTypeStrict(builder);
        }
        if (builder.getTokenType() == mIDENT) {
            return TypeSpec.parseClassOrInterfaceTypeStrict(builder);
        }
        return false;
    }

    private static boolean parseBuiltInTypeStrict(PsiBuilder builder) {
        PsiBuilder.Marker arrMarker = builder.mark();
        ParserUtils.eatElement(builder, BUILT_IN_TYPE);
        if (mLBRACK.equals(builder.getTokenType())) {
            return TypeSpec.declarationBracketsParseStrict(builder, arrMarker);
        }
        arrMarker.drop();
        return true;
    }

    private static boolean declarationBracketsParseStrict(PsiBuilder builder, PsiBuilder.Marker marker) {
        ParserUtils.getToken(builder, mLBRACK);
        if (!ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]))) {
            marker.rollbackTo();
            return false;
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)ARRAY_TYPE);
        if (mLBRACK.equals(builder.getTokenType())) {
            return TypeSpec.declarationBracketsParseStrict(builder, newMarker);
        }
        newMarker.drop();
        return true;
    }

    private static boolean parseClassOrInterfaceTypeStrict(PsiBuilder builder) {
        PsiBuilder.Marker arrMarker = builder.mark();
        PsiBuilder.Marker typeElementMarker = builder.mark();
        if (!ReferenceElement.parseReferenceElement(builder)) {
            typeElementMarker.drop();
            arrMarker.rollbackTo();
            return false;
        }
        typeElementMarker.done((IElementType)CLASS_TYPE_ELEMENT);
        if (mLBRACK.equals(builder.getTokenType())) {
            return TypeSpec.declarationBracketsParseStrict(builder, arrMarker);
        }
        arrMarker.drop();
        return true;
    }
}

