/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class HandlerUtils {
    private HandlerUtils() {
    }

    public static boolean isEnabled(@NotNull Editor editor, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Language language;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.isEnabled must not be null");
        }
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.isEnabled must not be null");
        }
        Project project = HandlerUtils.getProject(dataContext);
        if (project != null && (language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project)) == GroovyFileType.GROOVY_LANGUAGE) {
            return true;
        }
        return originalHandler == null || originalHandler.isEnabled(editor, dataContext);
    }

    public static boolean isReadOnly(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.isReadOnly must not be null");
        }
        if (editor.isViewer()) {
            return true;
        }
        Document document = editor.getDocument();
        return !document.isWritable();
    }

    public static boolean canBeInvoked(Editor editor, Project project) {
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        return HandlerUtils.getPsiFile(editor, project) != null;
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.getPsiFile must not be null");
        }
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.getPsiFile must not be null");
        }
        return HandlerUtils.getPsiFile(editor, HandlerUtils.getProject(dataContext));
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, Project project) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.getPsiFile must not be null");
        }
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
    }

    @Nullable
    public static Language getLanguage(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.getLanguage must not be null");
        }
        return (Language)DataKeys.LANGUAGE.getData(dataContext);
    }

    @Nullable
    public static Project getProject(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/editor/HandlerUtils.getProject must not be null");
        }
        return (Project)DataKeys.PROJECT.getData(dataContext);
    }
}

