/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    private static final String LINE_SEPARATOR = "\n";
    @NonNls
    private static final String PARAM_TAG = "@param";
    @NonNls
    private static final String RETURN_TAG = "@return";
    @NonNls
    private static final String THROWS_TAG = "@throws";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element) {
        if (element instanceof GrVariable) {
            GrVariable variable = (GrVariable)element;
            StringBuffer buffer = new StringBuffer();
            PsiType type = variable.getDeclaredType();
            GroovyDocumentationProvider.appendTypeString(buffer, type);
            buffer.append(" ");
            buffer.append(variable.getName());
            return buffer.toString();
        }
        if (element instanceof GrReferenceExpression) {
            GrExpression rvalue;
            GrAssignmentExpression assignment;
            GrReferenceExpression refExpr = (GrReferenceExpression)element;
            StringBuffer buffer = new StringBuffer();
            PsiType type = null;
            if (refExpr.getParent() instanceof GrAssignmentExpression && refExpr.equals((assignment = (GrAssignmentExpression)refExpr.getParent()).getLValue()) && (rvalue = assignment.getRValue()) != null) {
                type = rvalue.getType();
            }
            GroovyDocumentationProvider.appendTypeString(buffer, type);
            buffer.append(" ");
            buffer.append(refExpr.getReferenceName());
            return buffer.toString();
        }
        if (element instanceof PsiMethod) {
            StringBuffer buffer = new StringBuffer();
            PsiMethod method = (PsiMethod)element;
            if (method instanceof GrGdkMethod) {
                buffer.append("[GDK] ");
            } else {
                String qName;
                PsiClass hisClass = method.getContainingClass();
                if (hisClass != null && (qName = hisClass.getQualifiedName()) != null) {
                    buffer.append(qName).append(LINE_SEPARATOR);
                }
            }
            if (!method.isConstructor()) {
                GroovyDocumentationProvider.appendTypeString(buffer, method.getReturnType());
                buffer.append(" ");
            }
            buffer.append(method.getName()).append(" ");
            buffer.append("(");
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                if (parameter instanceof GrParameter) {
                    buffer.append(GroovyPresentationUtil.getParameterPresentation((GrParameter)parameter, PsiSubstitutor.EMPTY));
                    continue;
                }
                PsiType type = parameter.getType();
                GroovyDocumentationProvider.appendTypeString(buffer, type);
                buffer.append(" ");
                buffer.append(parameter.getName());
            }
            buffer.append(")");
            return buffer.toString();
        }
        if (element instanceof GrTypeDefinition) {
            return GroovyDocumentationProvider.generateClassInfo((GrTypeDefinition)element);
        }
        return null;
    }

    private static String generateClassInfo(PsiClass aClass) {
        PsiClassType[] refs;
        int i;
        StringBuffer buffer = new StringBuffer();
        GroovyFile file = (GroovyFile)aClass.getContainingFile();
        String packageName = file.getPackageName();
        if (packageName.length() > 0) {
            buffer.append(packageName).append(LINE_SEPARATOR);
        }
        String classString = aClass.isInterface() ? "interface" : (aClass instanceof PsiTypeParameter ? "type parameter" : (aClass.isEnum() ? "enum" : "class"));
        buffer.append(classString).append(" ");
        buffer.append(aClass.getName());
        if (aClass.hasTypeParameters()) {
            PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
            buffer.append("<");
            for (i = 0; i < typeParameters.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                PsiTypeParameter tp = typeParameters[i];
                buffer.append(tp.getName());
                PsiClassType[] refs2 = tp.getExtendsListTypes();
                if (refs2.length <= 0) continue;
                buffer.append(" extends ");
                for (int j = 0; j < refs2.length; ++j) {
                    if (j > 0) {
                        buffer.append(" & ");
                    }
                    GroovyDocumentationProvider.appendTypeString(buffer, (PsiType)refs2[j]);
                }
            }
            buffer.append(">");
        }
        if ((refs = aClass.getExtendsListTypes()).length > 0 || !aClass.isInterface() && !"java.lang.Object".equals(aClass.getQualifiedName())) {
            buffer.append(" extends ");
            if (refs.length == 0) {
                buffer.append("Object");
            } else {
                for (i = 0; i < refs.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    GroovyDocumentationProvider.appendTypeString(buffer, (PsiType)refs[i]);
                }
            }
        }
        if ((refs = aClass.getImplementsListTypes()).length > 0) {
            buffer.append("\nimplements ");
            for (i = 0; i < refs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                GroovyDocumentationProvider.appendTypeString(buffer, (PsiType)refs[i]);
            }
        }
        return buffer.toString();
    }

    private static void appendTypeString(StringBuffer buffer, PsiType type) {
        if (type != null) {
            buffer.append(type.getCanonicalText());
        } else {
            buffer.append("def");
        }
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return JavaDocumentationProvider.getExternalJavaDocUrl((PsiElement)element);
    }

    @Nullable
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        GrDocComment doc;
        if (element instanceof GrReferenceExpression) {
            return GroovyDocumentationProvider.getMethodCandidateInfo((GrReferenceExpression)element);
        }
        if (element instanceof GrGdkMethod) {
            element = ((GrGdkMethod)element).getStaticMethod();
        }
        if ((doc = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)originalElement, GrDocComment.class)) != null) {
            element = GrDocCommentUtil.findDocOwner(doc);
        }
        return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)element);
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        return JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element, (Project)project, docUrls);
    }

    private static String getMethodCandidateInfo(GrReferenceExpression expr) {
        GroovyResolveResult[] candidates = expr.multiResolve(false);
        String text = expr.getText();
        if (candidates.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (GroovyResolveResult candidate : candidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod)) continue;
                String str = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)candidate.getSubstitutor(), (int)259, (int)2);
                GroovyDocumentationProvider.createElementLink(sb, element, str);
            }
            return CodeInsightBundle.message((String)"javadoc.candiates", (Object[])new Object[]{text, sb});
        }
        return CodeInsightBundle.message((String)"javadoc.candidates.not.found", (Object[])new Object[]{text});
    }

    private static void createElementLink(@NonNls StringBuffer sb, PsiElement element, String str) {
        sb.append("&nbsp;&nbsp;<a href=\"psi_element://");
        sb.append(JavaDocUtil.getReferenceText((Project)element.getProject(), (PsiElement)element));
        sb.append("\">");
        sb.append(str);
        sb.append("</a>");
        sb.append("<br>");
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    public PsiComment findExistingDocComment(PsiComment contextElement) {
        GrDocCommentOwner owner;
        if (contextElement instanceof GrDocComment && (owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextElement)) != null) {
            return owner.getDocComment();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String generateDocumentationContentStub(PsiComment contextComment) {
        if (!(contextComment instanceof GrDocComment)) {
            return null;
        }
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner((GrDocComment)contextComment);
        if (owner == null) {
            return null;
        }
        Project project = contextComment.getProject();
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)LanguageCommenters.INSTANCE.forLanguage(owner.getLanguage());
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            PsiTypeParameterList typeParameterList;
            if (owner instanceof GrMethod) {
                void var13_20;
                PsiClassType[] psiClassTypeArray;
                PsiMethod[] superMethods;
                GrMethod method = (GrMethod)owner;
                GrParameter[] parameters = method.getParameters();
                HashMap param2Description = new HashMap();
                for (PsiMethod psiMethod : superMethods = method.findSuperMethods()) {
                    PsiDocTag[] params;
                    PsiDocComment comment = psiMethod.getDocComment();
                    if (comment == null) continue;
                    for (PsiDocTag param : params = comment.findTagsByName("param")) {
                        PsiElement[] dataElements = param.getDataElements();
                        if (dataElements == null) continue;
                        String paramName = null;
                        for (PsiElement dataElement : dataElements) {
                            if (!(dataElement instanceof PsiDocParamRef)) continue;
                            paramName = dataElement.getReference().getCanonicalText();
                            break;
                        }
                        if (paramName == null) continue;
                        param2Description.put(paramName, param.getText());
                    }
                }
                for (GrParameter grParameter : parameters) {
                    String description = (String)param2Description.get(grParameter.getName());
                    if (description != null) {
                        builder.append(CodeDocumentationUtil.createDocCommentLine((String)"", (Project)project, (CodeDocumentationAwareCommenter)commenter));
                        if (description.indexOf(10) > -1) {
                            description = description.substring(0, description.lastIndexOf(10));
                        }
                        builder.append(description);
                    } else {
                        builder.append(CodeDocumentationUtil.createDocCommentLine((String)PARAM_TAG, (Project)project, (CodeDocumentationAwareCommenter)commenter));
                        builder.append(grParameter.getName());
                    }
                    builder.append(LINE_SEPARATOR);
                }
                if ((method.getReturnType() != null || method.getModifierList().hasModifierProperty("def")) && method.getReturnType() != PsiType.VOID) {
                    builder.append(CodeDocumentationUtil.createDocCommentLine((String)RETURN_TAG, (Project)project, (CodeDocumentationAwareCommenter)commenter));
                    builder.append(LINE_SEPARATOR);
                }
                PsiClassType[] arr$ = psiClassTypeArray = method.getThrowsList().getReferencedTypes();
                int len$ = arr$.length;
                boolean bl = false;
                while (var13_20 < len$) {
                    PsiClassType reference = arr$[var13_20];
                    builder.append(CodeDocumentationUtil.createDocCommentLine((String)THROWS_TAG, (Project)project, (CodeDocumentationAwareCommenter)commenter));
                    builder.append(reference.getClassName());
                    builder.append(LINE_SEPARATOR);
                    ++var13_20;
                }
            } else if (owner instanceof GrTypeDefinition && (typeParameterList = ((PsiClass)owner).getTypeParameterList()) != null) {
                GroovyDocumentationProvider.createTypeParamsListComment(builder, project, commenter, typeParameterList);
            }
            String string = builder.length() > 0 ? builder.toString() : null;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private static void createTypeParamsListComment(StringBuilder buffer, Project project, CodeDocumentationAwareCommenter commenter, PsiTypeParameterList typeParameterList) {
        PsiTypeParameter[] typeParameters;
        for (PsiTypeParameter typeParameter : typeParameters = typeParameterList.getTypeParameters()) {
            buffer.append(CodeDocumentationUtil.createDocCommentLine((String)PARAM_TAG, (Project)project, (CodeDocumentationAwareCommenter)commenter));
            buffer.append("<").append(typeParameter.getName()).append(">");
            buffer.append(LINE_SEPARATOR);
        }
    }
}

