/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.processors;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public class GroovyPlainEnterProcessor
implements EnterProcessor {
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        GrCodeBlock block = this.getControlStatementBlock(editor.getCaretModel().getOffset(), psiElement);
        if (block != null) {
            PsiElement firstElement = block.getFirstChild().getNextSibling();
            editor.getCaretModel().moveToOffset(firstElement != null ? firstElement.getTextRange().getStartOffset() - 1 : block.getTextRange().getEndOffset());
        }
        this.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
        return true;
    }

    private EditorActionHandler getEnterHandler() {
        EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
        return enterHandler;
    }

    private GrCodeBlock getControlStatementBlock(int caret, PsiElement element) {
        GrStatement body = null;
        if (element instanceof GrIfStatement) {
            body = ((GrIfStatement)element).getThenBranch();
            if (caret > body.getTextRange().getEndOffset()) {
                body = ((GrIfStatement)element).getElseBranch();
            }
        } else if (element instanceof GrWhileStatement) {
            body = ((GrWhileStatement)element).getBody();
        } else if (element instanceof GrForStatement) {
            body = ((GrForStatement)element).getBody();
        }
        return body instanceof GrBlockStatement ? ((GrBlockStatement)body).getBlock() : null;
    }
}

