/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertIntegerToHexPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ConvertIntegerToHexIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToHexPredicate convertIntegerToHexPredicate = new ConvertIntegerToHexPredicate();
        if (convertIntegerToHexPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToHexIntention.getElementPredicate must not return null");
        }
        return convertIntegerToHexPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean isLong;
        int textLength;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToHexIntention.processIntention must not be null");
        }
        GrLiteral exp = (GrLiteral)element;
        String textString = exp.getText();
        char lastChar = textString.charAt((textLength = textString.length()) - 1);
        boolean bl = isLong = lastChar == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        BigInteger val = textString.charAt(0) == '0' ? new BigInteger(textString, 8) : new BigInteger(textString, 10);
        String hexString = "0x" + val.toString(16);
        if (isLong) {
            hexString = hexString + 'L';
        }
        IntentionUtils.replaceExpression(hexString, exp);
    }
}

