/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;
import org.jetbrains.plugins.groovy.gant.GantIcons;
import org.jetbrains.plugins.groovy.gant.GantUtils;

public class GantLibraryManager
extends AbstractGroovyLibraryManager {
    @Override
    public boolean managesLibrary(@NotNull Library library, LibrariesContainer container) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantLibraryManager.managesLibrary must not be null");
        }
        return GantUtils.isGantLibrary(container.getLibraryFiles(library, OrderRootType.CLASSES));
    }

    @Override
    @Nls
    public String getLibraryVersion(@NotNull Library library, LibrariesContainer librariesContainer) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantLibraryManager.getLibraryVersion must not be null");
        }
        return GantUtils.getGantVersion(GantUtils.getGantLibraryHome(librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES)));
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = GantIcons.GANT_SDK_ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantLibraryManager.getIcon must not return null");
        }
        return icon;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantLibraryManager.isSDKHome must not be null");
        }
        return GantUtils.isGantSdkHome(file);
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        String string = GantUtils.getGantVersion(path);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantLibraryManager.getSDKVersion must not return null");
        }
        return string;
    }

    @Override
    public Icon getDialogIcon() {
        return GantIcons.GANT_ICON_16x16;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Gant" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantLibraryManager.getLibraryCategoryName must not return null");
        }
        return "Gant";
    }

    @Override
    protected void fillLibrary(String path, Library.ModifiableModel model) {
        File lib;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            model.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        File[] fileArray = jars = (lib = new File(path + "/lib")).exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }
}

