/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyConfigUtils
extends AbstractConfigUtils {
    @NonNls
    public static final String GROOVY_ALL_JAR_PATTERN = "groovy-all-(.*)\\.jar";
    private static GroovyConfigUtils myGroovyConfigUtils;
    @NonNls
    public static final String GROOVY_JAR_PATTERN = "groovy-(\\d.*)\\.jar";
    public static final String NO_VERSION = "<no version>";

    private GroovyConfigUtils() {
    }

    public static GroovyConfigUtils getInstance() {
        if (myGroovyConfigUtils == null) {
            myGroovyConfigUtils = new GroovyConfigUtils(){
                {
                    this.STARTER_SCRIPT_FILE_NAME = "groovy";
                }
            };
        }
        return myGroovyConfigUtils;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getSDKVersion(@NotNull String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovyConfigUtils.getSDKVersion must not be null");
        }
        String groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF");
        if (groovyJarVersion != null) {
            String string2 = groovyJarVersion;
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyConfigUtils.getSDKVersion must not return null");
        }
        groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF");
        if (groovyJarVersion == null) return "undefined";
        String string3 = groovyJarVersion;
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyConfigUtils.getSDKVersion must not return null");
        return string;
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return LibrariesUtil.getGroovyLibraryHome(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    @Nullable
    public String getSDKVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovyConfigUtils.getSDKVersion must not be null");
        }
        String path = LibrariesUtil.getGroovyHomePath(module);
        if (path == null) {
            return null;
        }
        return this.getSDKVersion(path);
    }

    public boolean isAtLeastGroovy1_7(Module module) {
        if (module == null) {
            return false;
        }
        String version = this.getSDKVersion(module);
        if (version == null) {
            return false;
        }
        return version.compareTo("1.7") >= 0;
    }

    public boolean isAtLeastGroovy1_7(PsiElement psiElement) {
        return this.isAtLeastGroovy1_7(ModuleUtil.findModuleForPsiElement((PsiElement)psiElement));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getSDKVersion(PsiElement psiElement) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return NO_VERSION;
        }
        String s = this.getSDKVersion(module);
        if (s == null) return NO_VERSION;
        String string = s;
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyConfigUtils.getSDKVersion must not return null");
        return string2;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        if (file != null && file.isDirectory()) {
            String path = file.getPath();
            if (GroovyUtils.getFilesInDirectoryByPattern(path + "/lib", GROOVY_JAR_PATTERN).length > 0) {
                return true;
            }
            if (GroovyUtils.getFilesInDirectoryByPattern(path + "/embeddable", GROOVY_ALL_JAR_PATTERN).length > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean tryToSetUpGroovyFacetOntheFly(final Module module) {
        Project project = module.getProject();
        final Library[] libraries = this.getAllSDKLibraries(project);
        if (libraries.length > 0) {
            Library library = libraries[0];
            int result = Messages.showOkCancelDialog((String)GroovyBundle.message("groovy.like.library.found.text", module.getName(), library.getName(), this.getSDKLibVersion(library)), (String)GroovyBundle.message("groovy.like.library.found", new Object[0]), (Icon)GroovyIcons.GROOVY_ICON_32x32);
            final Ref ref = new Ref();
            ref.set((Object)false);
            if (result == 0) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                        LibraryOrderEntry entry = model.addLibraryEntry(libraries[0]);
                        LibrariesUtil.placeEntryToCorrectPlace(model, entry);
                        model.commit();
                        ref.set((Object)true);
                    }
                });
            }
            return (Boolean)ref.get();
        }
        return false;
    }

    @NotNull
    public String getSDKLibVersion(Library library) {
        String string = this.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(library));
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovyConfigUtils.getSDKLibVersion must not return null");
        }
        return string;
    }

    public Collection<String> getSDKVersions(Project project) {
        return ContainerUtil.map2List((Object[])this.getAllSDKLibraries(project), (Function)new Function<Library, String>(){

            public String fun(Library library) {
                return GroovyConfigUtils.this.getSDKLibVersion(library);
            }
        });
    }
}

