/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.GeneratePluginClassAction;
import org.jetbrains.idea.devkit.actions.NewActionDialog;
import org.jetbrains.idea.devkit.util.ActionType;

public class NewActionAction
extends GeneratePluginClassAction {
    private NewActionDialog myDialog;

    public NewActionAction() {
        super(DevKitBundle.message("new.menu.action.text", new Object[0]), DevKitBundle.message("new.menu.action.description", new Object[0]), null);
    }

    @Override
    protected PsiElement[] invokeDialogImpl(Project project, PsiDirectory directory) {
        this.myDialog = new NewActionDialog(project);
        this.myDialog.show();
        if (this.myDialog.getExitCode() == 0) {
            CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
            validator.canClose(this.myDialog.getActionName());
            this.myDialog = null;
            return validator.getCreatedElements();
        }
        this.myDialog = null;
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected void checkBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        JavaDirectoryService.getInstance().checkCreateClass(directory, newName);
        super.checkBeforeCreate(newName, directory);
    }

    @Override
    protected String getClassTemplateName() {
        return "Action.java";
    }

    @Override
    public void patchPluginXml(XmlFile pluginXml, PsiClass klass) throws IncorrectOperationException {
        ActionType.ACTION.patchPluginXml(pluginXml, klass, this.myDialog);
    }

    protected String getErrorTitle() {
        return DevKitBundle.message("new.action.error", new Object[0]);
    }

    protected String getCommandName() {
        return DevKitBundle.message("new.action.command", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return DevKitBundle.message("new.action.action.name", directory, newName);
    }
}

