/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.lf5.util.Resource;
import org.apache.log4j.lf5.util.ResourceUtils;
import org.apache.log4j.lf5.util.StreamUtils;

public class ProductProperties {
    protected Properties _productProperties = new Properties();
    private static ProductProperties _reference = null;
    private static Object _synchronizingObject = new Object();

    private ProductProperties() {
        this(new Resource("org/apache/log4j/lf5/lf5.properties"));
    }

    private ProductProperties(Resource resource) {
        try {
            InputStream source = this.getSource(resource);
            byte[] contents = StreamUtils.getBytes(source);
            this._productProperties = this.getProperties(contents);
            source.close();
            this.validateProductProperties();
        }
        catch (Exception e) {
            String error = e.getMessage();
            throw new ExceptionInInitializerError(error);
        }
    }

    public static ProductProperties getInstance() {
        if (_reference == null) {
            Object object = _synchronizingObject;
            synchronized (object) {
                if (_reference == null) {
                    _reference = new ProductProperties();
                }
            }
        }
        return _reference;
    }

    public static String getPropertyNameOfProductName() {
        return "product.name";
    }

    public static String getPropertyNameOfProductVersionNumber() {
        return "product.version.number";
    }

    public static String getPropertyNameOfProductReleaseDate() {
        return "product.release.date";
    }

    public String getProductName() {
        return this._productProperties.getProperty(ProductProperties.getPropertyNameOfProductName());
    }

    public void setProductName(String productName) {
        this._productProperties.setProperty(ProductProperties.getPropertyNameOfProductName(), productName);
    }

    public String getProductVersionNumber() {
        return this._productProperties.getProperty(ProductProperties.getPropertyNameOfProductVersionNumber());
    }

    public void setProductVersionNumber(String productVersionNumber) {
        this._productProperties.setProperty(ProductProperties.getPropertyNameOfProductVersionNumber(), productVersionNumber);
    }

    public String getProductReleaseDate() {
        return this._productProperties.getProperty(ProductProperties.getPropertyNameOfProductReleaseDate());
    }

    public void setProductReleaseDate(String productReleaseDate) {
        this._productProperties.setProperty(ProductProperties.getPropertyNameOfProductReleaseDate(), productReleaseDate);
    }

    public String get(String name) {
        return this._productProperties.getProperty(name);
    }

    public Object set(String name, String value) {
        return this._productProperties.setProperty(name, value);
    }

    public String getLogFactor5() {
        return this.getString("lf5");
    }

    public String getString(String propertyName) {
        return String.valueOf(this.get(propertyName));
    }

    protected void validateProductProperties() throws Exception {
        String value = null;
        value = this.getProductVersionNumber();
        if (value == null || value.equals("")) {
            throw new Exception("Product version number is null.");
        }
        value = this.getProductReleaseDate();
        if (value == null || value.equals("")) {
            throw new Exception("Product release date is null.");
        }
    }

    private InputStream getSource(Resource resource) {
        return new BufferedInputStream(ResourceUtils.getResourceAsStream(this, resource));
    }

    private Properties getProperties(byte[] contents) throws IOException {
        ByteArrayInputStream source = new ByteArrayInputStream(contents);
        Properties result = new Properties();
        result.load(source);
        source.close();
        return result;
    }
}

