#!/bin/sh
echo 'name: tagsoup
version: 0.12.8
id: tagsoup-0.12.8-f3e972ad4d5ae14641947ff5b061bcfb

license: BSD3
copyright: Neil Mitchell 2006-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/tagsoup/
package-url:
synopsis: Parsing and extracting information from (possibly malformed) HTML/XML documents
description: TagSoup is a library for parsing HTML/XML. It supports the HTML 5 specification,
             and can be used to parse either well-formed XML, or unstructured and malformed HTML
             from the web. The library also provides useful functions to extract information
             from an HTML document, making it ideal for screen-scraping.
             .
             Users should start from the "Text.HTML.TagSoup" module.
category: XML
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: textproc/hs-tagsoup
exposed: True
exposed-modules: Text.HTML.Download Text.HTML.TagSoup
                 Text.HTML.TagSoup.Entity Text.HTML.TagSoup.Match
                 Text.HTML.TagSoup.Tree Text.StringLike
hidden-modules: Text.HTML.TagSoup.Generated
                Text.HTML.TagSoup.Implementation Text.HTML.TagSoup.Manual
                Text.HTML.TagSoup.Options Text.HTML.TagSoup.Parser
                Text.HTML.TagSoup.Render Text.HTML.TagSoup.Specification
                Text.HTML.TagSoup.Type
trusted: False
import-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
library-dirs: /usr/local/lib/ghc/tagsoup-0.12.8
hs-libraries: HStagsoup-0.12.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         network-2.3.1.0-abef231ef624b7502aa8b0353f2d5ca3
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tagsoup-0.12.8/html/tagsoup.haddock
haddock-html: /usr/local/share/doc/hs-tagsoup-0.12.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
