#!/bin/sh
echo 'name: snap-core
version: 0.9.2.2
id: snap-core-0.9.2.2-f344f1a99fc30d79b2b3b0193c2a6a0e

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Snap: A Haskell Web Framework (core interfaces and types)
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core",
             some iteratee utilities are in "Snap.Iteratee".
category: Web, Snap
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Core Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Exceptions
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Test Snap.Types.Headers
                 Snap.Util.FileServe Snap.Util.FileUploads Snap.Util.GZip
                 Snap.Util.Proxy Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool
                Snap.Internal.Parsing.FastSet Snap.Internal.Routing
                Snap.Internal.Types Snap.Internal.Test.RequestBuilder
                Snap.Internal.Test.Assertions
trusted: False
import-dirs: /usr/local/lib/ghc/snap-core-0.9.2.2
library-dirs: /usr/local/lib/ghc/snap-core-0.9.2.2
hs-libraries: HSsnap-core-0.9.2.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.1-3a320959e06d702551395cbe60e9b4d5
         MonadCatchIO-transformers-0.3.0.0-76541279080d15c89bf5cb94558aa9e1
         attoparsec-0.10.1.0-5f1c2093e40bb5451ff760048cacce00
         attoparsec-enumerator-0.3-1157b0e45bcb851e604a4f659376fa71
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         blaze-builder-0.2.1.4-7e5834be78fd9cd5b05f4a14f4001d18
         blaze-builder-enumerator-0.2.0.4-f7318c0e9f00aac67a8e1aba630ee48e
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         bytestring-mmap-0.2.2-a846504afe4e3956abe0387219057f81
         case-insensitive-0.4.0.1-aede33a6adf1c74693aeb44c801bd09f
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         deepseq-1.3.0.0-c26e15897417ecd448742528253d68f6
         directory-1.1.0.2-da0a8c62c2b42ae7a3b538f5fee58422
         enumerator-0.4.19-27ff248ca60645d7b3b73b44ac567b75
         filepath-1.3.0.0-f998e5510c76a98913f57b14b4f16c57
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         random-1.0.1.1-d8f82f84701874725b418c29860a58e0
         regex-posix-0.95.2-62c27af122347b4aae6289df5cd7f9ee
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
         time-1.4-d61e2caaa0486655b4e141dc277ed49f
         unix-2.5.1.1-0adea5be633a6b5a124519287d54626d
         unix-compat-0.3.0.1-b66f7546fa6d25faf14bd9cb263a6d3b
         unordered-containers-0.1.4.6-a7207f78d453daba3716dfc838a574ed
         vector-0.10.0.1-3450daae3d9f2092020075d05481123c
         zlib-enum-0.2.2.1-850fd31afe82d4ad04cd29118b119441
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.9.2.2/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.9.2.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
