#!/bin/sh
echo 'name: skein
version: 0.1.0.9
id: skein-0.1.0.9-58bb4d5b0be90d2686a8184b233452c3

license: BSD3
copyright:
maintainer: Felipe Lessa <felipe.lessa@gmail.com>
stability:
homepage: https://github.com/meteficha/skein
package-url:
synopsis: Skein, a family of cryptographic hash functions.  Includes Skein-MAC as well.
description: Skein (<http://www.skein-hash.info/>) is a family of fast
             secure cryptographic hash functions designed by Niels
             Ferguson, Stefan Lucks, Bruce Schneier, Doug Whiting, Mihir
             Bellare, Tadayoshi Kohno, Jon Callas and Jesse Walker.
             .
             This package uses bindings to the optimized C implementation
             of Skein.  We provide a high-level interface (see module
             "Crypto.Skein") to some of the Skein use cases.  We also
             provide a low-level interface (see module
             "Crypto.Skein.Internal") should you need to use Skein in a
             different way.
             .
             Currently we have support for Skein as cryptographic hash
             function as Skein as a message authentication code
             (Skein-MAC).  For examples of how to use this package, see
             "Crypto.Skein" module documentation.
category: Cryptography
author: Felipe Lessa <felipe.lessa@gmail.com>, Doug Whiting
pkgpath: security/hs-skein
exposed: True
exposed-modules: Crypto.Skein Crypto.Skein.Internal
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/skein-0.1.0.9
library-dirs: /usr/local/lib/ghc/skein-0.1.0.9
hs-libraries: HSskein-0.1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes: skein.h
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         cereal-0.3.5.2-807bd944bfc86ac5df2f667be96ad9f0
         crypto-api-0.10.2-b894ddbcbc6462caabf9766373a4cdd1
         tagged-0.4.4-886769b727dcf06f0418d254f5119104
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-skein-0.1.0.9/html/skein.haddock
haddock-html: /usr/local/share/doc/hs-skein-0.1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
