#!/bin/sh
echo 'name: semigroupoids
version: 1.3.4
id: semigroupoids-1.3.4-f6cac02bc81f1b90cb5781134a5d6e49

license: BSD3
copyright: Copyright (C) 2011 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
package-url:
synopsis: Haskell 98 semigroupoids: Category sans id
description: Provides a wide array of semigroupoids and operations for working with semigroupds.
             .
             A Semigroupoid is a Category without the requirement of identity arrows for every object in the category.
             .
             When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
             not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
             in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
             .
             Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
             .
             .
             Ideally the following relationships would hold:
             .
             > Traversable <---- Foldable <--- Functor ------> Alt ---------> Plus           Semigroupoid
             >      |               |            |                              |                  |
             >      v               v            v                              v                  v
             > Traversable1 <--- Foldable1     Apply --------> Applicative -> Alternative      Category
             >                                   |               |              |                  |
             >                                   v               v              v                  v
             >                                 Bind ---------> Monad -------> MonadPlus          Arrow
             >
             .
             Apply, Bind, and Extract give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
             .
             This lets us remove many of the restrictions from various monad transformers
             as in many cases the binding operation or @\<*\>@ operation does not require them.
             .
             Finally, to work with these weaker structures it is beneficial to have containers
             that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
             and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
pkgpath: devel/hs-semigroupoids
exposed: True
exposed-modules: Data.Functor.Alt Data.Functor.Apply
                 Data.Functor.Bind Data.Functor.Bind.Trans Data.Functor.Plus
                 Data.Semigroup.Foldable Data.Semigroup.Traversable
                 Data.Semigroupoid Data.Semigroupoid.Dual Data.Semigroupoid.Static
                 Data.Traversable.Instances
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/semigroupoids-1.3.4
library-dirs: /usr/local/lib/ghc/semigroupoids-1.3.4
hs-libraries: HSsemigroupoids-1.3.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         comonad-1.1.1.6-1ab55e9c35a79b8bc4ee534d99a53a51
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         contravariant-0.2.0.2-a904f04c113b714e9e395ee37d9f46c4
         semigroups-0.8.3.2-08bd9e08e0f404cc4af18eab242e78de
         transformers-0.3.0.0-8e66ecc7d4dae2b07b2b5406908c70e4
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-semigroupoids-1.3.4/html/semigroupoids.haddock
haddock-html: /usr/local/share/doc/hs-semigroupoids-1.3.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
