#!/bin/sh
echo 'name: pango
version: 0.12.3
id: pango-0.12.3-0528a1fb56da14e2685d92b92eabe3c3

license: LGPL-2.1
copyright: (c) 2001-2010 The Gtk2Hs Team
maintainer: gtk2hs-users@lists.sourceforge.net
stability: stable
homepage: http://projects.haskell.org/gtk2hs/
package-url:
synopsis: Binding to the Pango text rendering engine.
description: This package provides a wrapper around the Pango C library that
             allows high-quality rendering of Unicode text. It can be used
             either with Cairo to output text in PDF, PS or other
             documents or with Gtk+ to display text on-screen.
category: Graphics
author: Axel Simon, Duncan Coutts
pkgpath: devel/hs-pango
exposed: True
exposed-modules: Graphics.Rendering.Pango
                 Graphics.Rendering.Pango.Font Graphics.Rendering.Pango.Enums
                 Graphics.Rendering.Pango.Context Graphics.Rendering.Pango.Layout
                 Graphics.Rendering.Pango.Rendering Graphics.Rendering.Pango.Markup
                 Graphics.Rendering.Pango.Cairo Graphics.Rendering.Pango.Types
                 Graphics.Rendering.Pango.BasicTypes
                 Graphics.Rendering.Pango.Structs
                 Graphics.Rendering.Pango.Attributes
hidden-modules: Graphics.Rendering.Pango.GlyphStorage
                Graphics.Rendering.Pango.Description
trusted: False
import-dirs: /usr/local/lib/ghc/pango-0.12.3
library-dirs: /usr/local/lib/ghc/pango-0.12.3 /usr/local/lib
              /usr/X11R6/lib
hs-libraries: HSpango-0.12.3
extra-libraries: pangocairo-1.0 cairo pangoft2-1.0 pango-1.0 m
                 gobject-2.0 glib-2.0 intl iconv fontconfig expat freetype z
extra-ghci-libraries:
include-dirs: /usr/local/include/pango-1.0 /usr/local/include/cairo
              /usr/X11R6/include/pixman-1 /usr/local/include/libpng
              /usr/X11R6/include /usr/local/include/harfbuzz
              /usr/local/include/glib-2.0 /usr/local/lib/glib-2.0/include
              /usr/local/include /usr/X11R6/include/freetype2
includes: hspango.h
depends: array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         cairo-0.12.3.1-7b7e0b628bdcf7f56725c71496ba1e42
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         directory-1.1.0.2-da0a8c62c2b42ae7a3b538f5fee58422
         glib-0.12.3.1-8ac5b4e3ebf09c745ad0f6b285d2dd5a
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         pretty-1.1.1.0-91ed62f0481a81d292d550eec35ee75b
         process-1.1.0.1-608c248c1528f46eb960a08cead77291
hugs-options:
cc-options:
ld-options: "-Wl,-rpath-link,/usr/X11R6/lib"
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-pango-0.12.3/html/pango.haddock
haddock-html: /usr/local/share/doc/hs-pango-0.12.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
