#!/bin/sh
echo 'name: monad-control
version: 0.3.1.4
id: monad-control-0.3.1.4-83560fedcd54bda582bc1867a61c5f8a

license: BSD3
copyright: (c) 2011 Bas van Dijk, Anders Kaseorg
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
stability:
homepage: https://github.com/basvandijk/monad-control
package-url:
synopsis: Lift control operations, like exception catching, through monad transformers
description: This package defines the type class @MonadBaseControl@, a subset of
             @MonadBase@ into which generic control operations such as @catch@ can be
             lifted from @IO@ or any other base monad. Instances are based on monad
             transformers in @MonadTransControl@, which includes all standard monad
             transformers in the @transformers@ library except @ContT@.
             .
             See the @lifted-base@ package which uses @monad-control@ to lift @IO@
             operations from the @base@ library (like @catch@ or @bracket@) into any monad
             that is an instance of @MonadBase@ or @MonadBaseControl@.
             .
             Note that this package is a rewrite of Anders Kaseorg'\''s @monad-peel@
             library. The main difference is that this package provides CPS style operators
             and exploits the @RankNTypes@ and @TypeFamilies@ language extensions to
             simplify and speedup most definitions.
             .
             The following @criterion@ based benchmark shows that @monad-control@ is on
             average about 99% faster than @monad-peel@:
             .
             @git clone <https://github.com/basvandijk/bench-monad-peel-control>@
category: Control
author: Bas van Dijk, Anders Kaseorg
pkgpath: devel/hs-monad-control
exposed: True
exposed-modules: Control.Monad.Trans.Control
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/monad-control-0.3.1.4
library-dirs: /usr/local/lib/ghc/monad-control-0.3.1.4
hs-libraries: HSmonad-control-0.3.1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         base-unicode-symbols-0.2.2.4-47de1db137e54c7919bd23c17263184a
         transformers-0.3.0.0-8e66ecc7d4dae2b07b2b5406908c70e4
         transformers-base-0.4.1-8ce92ed550a5d340c6fea5db639117cb
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-monad-control-0.3.1.4/html/monad-control.haddock
haddock-html: /usr/local/share/doc/hs-monad-control-0.3.1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
