#!/bin/sh
echo 'name: hashed-storage
version: 0.5.9
id: hashed-storage-0.5.9-5e70788c643c98d2b21c86aa73e7cee4

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
synopsis: Hashed file storage support code.
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.9
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.9
hs-libraries: HShashed-storage-0.5.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         binary-0.5.1.0-02f9fe068644b2c45302cea43b257ad5
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         dataenc-0.14.0.3-de84533a90515987298bdce19a0f1916
         directory-1.1.0.2-da0a8c62c2b42ae7a3b538f5fee58422
         extensible-exceptions-0.1.1.4-3d9bd197c43329612c640f24179a7f19
         filepath-1.3.0.0-f998e5510c76a98913f57b14b4f16c57
         mmap-0.5.6-10c47875abe1f5fdfd271cc23819ac7b
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         zlib-0.5.4.0-f9a7b27d857d3e506b8524567650abc8
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.9/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
