#!/bin/sh
echo 'name: cprng-aes
version: 0.2.3
id: cprng-aes-0.2.3-5a1be364f8388eb7673eb9efda09c6bf

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-cprng-aes
package-url:
synopsis: Crypto Pseudo Random Number Generator using AES in counter mode.
description: Simple crypto pseudo-random-number-generator with really good randomness property.
             .
             Using ent, a randomness property maker on one 1Mb sample:
             Entropy = 7.999837 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 237.02
             Arithmetic mean value of data bytes is 127.3422 (127.5 = random)
             Monte Carlo value for Pi is 3.143589568 (error 0.06 percent)
             .
             Compared to urandom with the same sampling:
             Entropy = 7.999831 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 246.63
             Arithmetic mean value of data bytes is 127.6347 (127.5 = random).
             Monte Carlo value for Pi is 3.132465868 (error 0.29 percent).
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cprng-aes
exposed: True
exposed-modules: Crypto.Random.AESCtr
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
library-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
hs-libraries: HScprng-aes-0.2.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         cereal-0.3.5.2-807bd944bfc86ac5df2f667be96ad9f0
         crypto-api-0.10.2-b894ddbcbc6462caabf9766373a4cdd1
         cryptocipher-0.2.8-5db28d4ca7124fa3cb1d1c1adca93dea
         entropy-0.2.1-c84e6c51abcd6575cd8db3e7ab93fdf7
         random-1.0.1.1-d8f82f84701874725b418c29860a58e0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cprng-aes-0.2.3/html/cprng-aes.haddock
haddock-html: /usr/local/share/doc/hs-cprng-aes-0.2.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
