#!/bin/sh
echo 'name: configurator
version: 0.2.0.0
id: configurator-0.2.0.0-dd1b32e41feb8d446ee89308d3c09a54

license: BSD3
copyright: Copyright 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: http://github.com/bos/configurator
package-url:
synopsis: Configuration management
description: A configuration management library for programs and daemons.
             .
             Features include:
             .
             * Automatic, dynamic reloading in response to modifications to
             configuration files.
             .
             * A simple, but flexible, configuration language, supporting several
             of the most commonly needed types of data, along with
             interpolation of strings from the configuration or the system
             environment (e.g. @$(HOME)@).
             .
             * Subscription-based notification of changes to configuration
             properties.
             .
             * An @import@ directive allows the configuration of a complex
             application to be split across several smaller files, or common
             configuration data to be shared across several applications.
             .
             For details of the configuration file format, see
             <http://hackage.haskell.org/packages/archive/configurator/latest/doc/html/Data-Configurator.html>.
category: Configuration, Data
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-configurator
exposed: True
exposed-modules: Data.Configurator Data.Configurator.Types
hidden-modules: Data.Configurator.Instances
                Data.Configurator.Parser Data.Configurator.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
library-dirs: /usr/local/lib/ghc/configurator-0.2.0.0
hs-libraries: HSconfigurator-0.2.0.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.1.0-5f1c2093e40bb5451ff760048cacce00
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         directory-1.1.0.2-da0a8c62c2b42ae7a3b538f5fee58422
         hashable-1.1.2.3-d030b9fe5b35dcb16975530055dde91a
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
         unix-compat-0.3.0.1-b66f7546fa6d25faf14bd9cb263a6d3b
         unordered-containers-0.1.4.6-a7207f78d453daba3716dfc838a574ed
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-configurator-0.2.0.0/html/configurator.haddock
haddock-html: /usr/local/share/doc/hs-configurator-0.2.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
