#!/bin/sh
echo 'name: conduit
version: 0.4.2
id: conduit-0.4.2-a0b427f452bae4a4b64ddd41062500c2

license: BSD3
copyright:
maintainer: michael@snoyman.com
stability:
homepage: http://github.com/snoyberg/conduit
package-url:
synopsis: Streaming data processing library.
description: Conduits are an approach to the streaming data problem. It is meant as an alternative to enumerators\/iterators, hoping to address the same issues with different trade-offs based on real-world experience with enumerators. For more information, see <http://www.yesodweb.com/book/conduits>.
             .
             Release history:
             .
             [0.4] Inspired by the design of the pipes package: we now have a single unified type underlying @Source@, @Sink@, and @Conduit@. This type is named @Pipe@. There are type synonyms provided for the other three types. Additionally, @BufferedSource@ is no longer provided. Instead, the connect-and-resume operator, @$$+@, can be used for the same purpose.
             .
             [0.3] ResourceT has been greatly simplified, specialized for IO, and moved into a separate package. Instead of hard-coding ResourceT into the conduit datatypes, they can now live around any monad. The Conduit datatype has been enhanced to better allow generation of streaming output. The SourceResult, SinkResult, and ConduitResult datatypes have been removed entirely.
             .
             [0.2] Instead of storing state in mutable variables, we now use CPS. A @Source@ returns the next @Source@, and likewise for @Sink@s and @Conduit@s. Not only does this take better advantage of GHC\'\''s optimizations (about a 20% speedup), but it allows some operations to have a reduction in algorithmic complexity from exponential to linear. This also allowed us to remove the @Prepared@ set of types. Also, the @State@ functions (e.g., @sinkState@) use better constructors for return types, avoiding the need for a dummy state on completion.
             .
             [0.1] @BufferedSource@ is now an abstract type, and has a much more efficient internal representation. The result was a 41% speedup on microbenchmarks (note: do not expect speedups anywhere near that in real usage). In general, we are moving towards @BufferedSource@ being a specific tool used internally as needed, but using @Source@ for all external APIs.
             .
             [0.0] Initial release.
category: Data, Conduit
author: Michael Snoyman
pkgpath: devel/hs-conduit
exposed: True
exposed-modules: Data.Conduit Data.Conduit.Binary Data.Conduit.Text
                 Data.Conduit.List Data.Conduit.Lazy Data.Conduit.Internal
hidden-modules: System.PosixFile Data.Conduit.Util.Source
                Data.Conduit.Util.Sink Data.Conduit.Util.Conduit
trusted: False
import-dirs: /usr/local/lib/ghc/conduit-0.4.2
library-dirs: /usr/local/lib/ghc/conduit-0.4.2
hs-libraries: HSconduit-0.4.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         lifted-base-0.1.1.1-86ebf6ea1e464d5b4cf7b5f869c29baa
         monad-control-0.3.1.4-83560fedcd54bda582bc1867a61c5f8a
         resourcet-0.3.3.1-182a1ca09ebcb9fc1bcb2ce57788ad87
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
         transformers-0.3.0.0-8e66ecc7d4dae2b07b2b5406908c70e4
         transformers-base-0.4.1-8ce92ed550a5d340c6fea5db639117cb
         void-0.5.6-b88e036caef8e5f3387cb0b125f2cb08
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-conduit-0.4.2/html/conduit.haddock
haddock-html: /usr/local/share/doc/hs-conduit-0.4.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
