#!/bin/sh
echo 'name: attoparsec-enumerator
version: 0.3
id: attoparsec-enumerator-0.3-1157b0e45bcb851e604a4f659376fa71

license: MIT
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/attoparsec-enumerator/
package-url:
synopsis: Pass input from an enumerator to an Attoparsec parser.
description: This library allows an Attoparsec parser to receive input incrementally
             from an enumerator. This could be used for parsing large files, or
             implementing binary network protocols.
             .
             > (-# LANGUAGE OverloadedStrings #-)
             >
             > import Control.Applicative
             > import Data.Attoparsec
             > import Data.Attoparsec.Enumerator
             > import Data.Enumerator
             > import Data.Enumerator.Binary (enumHandle)
             > import Data.Enumerator.List
             > import System.IO
             >
             > parser = string "foo" <|> string "bar"
             >
             > main = do
             >     xy <- run_ (enumHandle 1 stdin $$ do
             >         x <- iterParser parser
             >         y <- iterParser parser
             >         return (x, y))
             >     print xy
category: Text, Parsing, Enumerator
author: John Millikin <jmillikin@gmail.com>
pkgpath: textproc/hs-attoparsec-enumerator
exposed: True
exposed-modules: Data.Attoparsec.Enumerator
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3
library-dirs: /usr/local/lib/ghc/attoparsec-enumerator-0.3
hs-libraries: HSattoparsec-enumerator-0.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.1.0-5f1c2093e40bb5451ff760048cacce00
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         enumerator-0.4.19-27ff248ca60645d7b3b73b44ac567b75
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-attoparsec-enumerator-0.3/html/attoparsec-enumerator.haddock
haddock-html: /usr/local/share/doc/hs-attoparsec-enumerator-0.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
