#!/bin/sh
echo 'name: aeson
version: 0.6.0.2
id: aeson-0.6.0.2-f7556912ff394379ee5d89d8deccabe9

license: BSD3
copyright: (c) 2011 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: https://github.com/bos/aeson
package-url:
synopsis: Fast JSON parsing and encoding
description: A JSON parsing and encoding library optimized for ease of use
             and high performance.
             .
             To get started, see the documentation for the @Data.Aeson@ module
             below.
             .
             For release notes, see
             <https://github.com/bos/aeson/blob/master/release-notes.markdown>
             .
             /Note/: if you use GHCi or Template Haskell, please see the
             @README@ file for important details about building this package,
             and other packages that depend on it:
             <https://github.com/bos/aeson#readme>
             .
             Parsing performance on a late 2010 MacBook Pro (2.66GHz Core i7),
             for mostly-English tweets from Twitter'\''s JSON search API:
             .
             * 0.8 KB, 32-bit GHC 6.12.3: 30538 msg\/sec (24.9 MB\/sec)
             .
             * 0.8 KB, 64-bit GHC 7.0.3: 31204 msg\/sec (25.4 MB\/sec)
             .
             * 6.4 KB, 32-bit GHC 6.12.3: 6731 msg\/sec (42.3 MB\/sec)
             .
             * 6.4 KB, 64-bit GHC 7.0.3: 6627 msg\/sec (41.7 MB\/sec)
             .
             * 11.8 KB, 32-bit GHC 6.12.3: 3751 msg\/sec (43.2 MB\/sec)
             .
             * 11.8 KB, 64-bit GHC 7.0.3: 3381 msg\/sec (38.9 MB\/sec)
             .
             * 31.2 KB, 32-bit GHC 6.12.3: 1306 msg\/sec (39.8 MB\/sec)
             .
             * 31.2 KB, 64-bit GHC 7.0.3: 1132 msg\/sec (34.5 MB\/sec)
             .
             * 61.5 KB, 32-bit GHC 6.12.3: 616 msg\/sec (37.0 MB\/sec)
             .
             * 61.5 KB, 64-bit GHC 7.0.3: 534 msg\/sec (32.1 MB\/sec)
             .
             Handling heavily-escaped text is a little more work.  Here is
             parsing performance with Japanese tweets, where much of the text
             is entirely Unicode-escaped.
             .
             * 14.6 KB, 32-bit GHC 6.12.3: 2315 msg\/sec (33.1 MB\/sec)
             .
             * 14.6 KB, 64-bit GHC 7.0.3: 1986 msg\/sec (28.4 MB\/sec)
             .
             * 44.1 KB, 32-bit GHC 6.12.3: 712 msg\/sec (30.7 MB\/sec)
             .
             * 44.1 KB, 64-bit GHC 7.0.3: 634 msg\/sec (27.3 MB\/sec)
             .
             * 82.9 KB, 32-bit GHC 6.12.3: 377 msg\/sec (30.5 MB\/sec)
             .
             * 82.9 KB, 64-bit GHC 7.0.3: 332 msg\/sec (26.9 MB\/sec)
             .
             Encoding performance on the same machine and data:
             .
             * English, 854 bytes: 43439 msg\/sec (35.4 MB/sec)
             .
             * English, 6.4 KB: 7127 msg\/sec (44.8 MB/sec)
             .
             * Engish, 61.5 KB: 765 msg\/sec (46.0 MB/sec)
             .
             * Japanese, 14.6 KB: 4727 msg\/sec (67.5 MB/sec)
             .
             * Japanese, 44.1 KB: 1505 msg\/sec (64.8 MB/sec)
             .
             (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-aeson
exposed: True
exposed-modules: Data.Aeson Data.Aeson.Encode Data.Aeson.Generic
                 Data.Aeson.Parser Data.Aeson.Types Data.Aeson.TH
hidden-modules: Data.Aeson.Types.Generic Data.Aeson.Functions
                Data.Aeson.Parser.Internal Data.Aeson.Types.Class
                Data.Aeson.Types.Internal
trusted: False
import-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
library-dirs: /usr/local/lib/ghc/aeson-0.6.0.2
hs-libraries: HSaeson-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.10.1.0-5f1c2093e40bb5451ff760048cacce00
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         blaze-builder-0.2.1.4-7e5834be78fd9cd5b05f4a14f4001d18
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         deepseq-1.3.0.0-c26e15897417ecd448742528253d68f6
         dlist-0.5-0a85ac8c26ac389fee97a9a8948c99ba
         ghc-prim-0.2.0.0-7d3c2c69a5e8257a04b2c679c40e2fa7
         hashable-1.1.2.3-d030b9fe5b35dcb16975530055dde91a
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         old-locale-1.0.0.4-5e45cabd3b4fdcad9e353ea3845f5ef7
         syb-0.3.7-60af41a2377e93620710d393692aff24
         template-haskell-2.7.0.0-826c08e99d445bf7fa4a34d70f491207
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
         time-1.4-d61e2caaa0486655b4e141dc277ed49f
         unordered-containers-0.1.4.6-a7207f78d453daba3716dfc838a574ed
         vector-0.10.0.1-3450daae3d9f2092020075d05481123c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-aeson-0.6.0.2/html/aeson.haddock
haddock-html: /usr/local/share/doc/hs-aeson-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
