#!/bin/sh
echo 'name: ListLike
version: 3.1.5
id: ListLike-3.1.5-b6360467630524a4cac94984a96dd38d

license: BSD3
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Lato <jwlato@gmail.com>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
synopsis: Generic support for list-like structures
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.CharString Data.ListLike.FoldableLL Data.ListLike.IO
                 Data.ListLike.Instances Data.ListLike.String Data.ListLike.Utils
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/ListLike-3.1.5
library-dirs: /usr/local/lib/ghc/ListLike-3.1.5
hs-libraries: HSListLike-3.1.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-3.1.5/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-3.1.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
