/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    protected PropertyChangeListener propertyChangeListener;

    public BasicMenuUI() {
        this.mouseInputListener = this.createMouseInputListener((JMenu)this.menuItem);
        this.menuListener = this.createMenuListener((JMenu)this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener((JMenu)this.menuItem);
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return new ChangeHandler((JMenu)c, this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    protected MenuListener createMenuListener(JComponent c) {
        return new MenuHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new BasicMenuItemUI.PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return c.getPreferredSize();
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuItem, "Menu.border");
        LookAndFeel.installColorsAndFont(this.menuItem, "Menu.background", "Menu.foreground", "Menu.font");
        this.menuItem.setMargin(UIManager.getInsets("Menu.margin"));
        this.acceleratorFont = UIManager.getFont("Menu.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("Menu.acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor("Menu.selectionBackground");
        this.selectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        this.oldBorderPainted = UIManager.getBoolean("Menu.borderPainted");
        ((JMenu)this.menuItem).setDelay(200);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void installListeners() {
        super.installListeners();
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
    }

    protected void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new SelectMenuAction());
        timer.setRepeats(false);
        timer.start();
    }

    protected void uninstallDefaults() {
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.arrowIcon = null;
    }

    protected void uninstallKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
    }

    public class ChangeHandler
    implements ChangeListener {
        public boolean isSelected;
        public JMenu menu;
        public BasicMenuUI ui;
        public Component wasFocused;

        public ChangeHandler(JMenu m, BasicMenuUI ui) {
            this.menu = m;
            this.ui = ui;
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            if (BasicMenuUI.this.menuItem.isEnabled()) {
                Component comp;
                MenuSelectionManager manager = e.getMenuSelectionManager();
                MenuElement[] path = e.getPath();
                Point p = e.getPoint();
                if (p.x >= 0 && p.x < BasicMenuUI.this.menuItem.getWidth() && p.y >= 0 && p.y < BasicMenuUI.this.menuItem.getHeight()) {
                    JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
                    MenuElement[] selectedPath = manager.getSelectedPath();
                    if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                        if (menu.isTopLevelMenu() || menu.getDelay() == 0 || e.getID() == 506) {
                            MenuElement[] newPath = new MenuElement[path.length + 1];
                            System.arraycopy(path, 0, newPath, 0, path.length);
                            newPath[path.length] = menu.getPopupMenu();
                            manager.setSelectedPath(newPath);
                        } else {
                            manager.setSelectedPath(path);
                            BasicMenuUI.this.setupPostTimer(menu);
                        }
                    }
                } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                    manager.clearSelectedPath();
                }
            }
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }
    }

    private class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuCanceled(MenuEvent e) {
            this.menuDeselected(e);
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (menu.getParent() != null) {
                if (menu.isTopLevelMenu()) {
                    ((JMenuBar)menu.getParent()).getSelectionModel().clearSelection();
                } else {
                    ((JPopupMenu)menu.getParent()).getSelectionModel().clearSelection();
                }
            }
        }

        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (menu.isTopLevelMenu()) {
                ((JMenuBar)menu.getParent()).setSelected(menu);
            } else {
                ((JPopupMenu)menu.getParent()).setSelected(menu);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) throws NotImplementedException {
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        private boolean popupVisible() {
            JMenuBar mb = (JMenuBar)((JMenu)BasicMenuUI.this.menuItem).getParent();
            if (!mb.isSelected()) {
                return false;
            }
            int i = 0;
            while (i < mb.getMenuCount()) {
                JMenu m = mb.getMenu(i);
                if (m != null && m.isPopupMenuVisible()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (menu.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (!menu.isTopLevelMenu()) {
                    if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                        if (menu.getDelay() == 0) {
                            MenuElement[] path = BasicMenuUI.this.getPath();
                            MenuElement[] newPath = new MenuElement[path.length + 1];
                            System.arraycopy(path, 0, newPath, 0, path.length);
                            newPath[path.length] = menu.getPopupMenu();
                            manager.setSelectedPath(newPath);
                        } else {
                            manager.setSelectedPath(BasicMenuUI.this.getPath());
                            BasicMenuUI.this.setupPostTimer(menu);
                        }
                    }
                } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                    MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (menu.isEnabled()) {
                MenuElement[] selectedPath;
                if (menu.isTopLevelMenu()) {
                    if (menu.isSelected()) {
                        manager.clearSelectedPath();
                    } else {
                        Container cnt = menu.getParent();
                        if (cnt != null && cnt instanceof JMenuBar) {
                            MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                            manager.setSelectedPath(me);
                        }
                    }
                }
                if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                        MenuElement[] newPath = new MenuElement[selectedPath.length + 1];
                        System.arraycopy(selectedPath, 0, newPath, 0, selectedPath.length);
                        newPath[selectedPath.length] = menu.getPopupMenu();
                        manager.setSelectedPath(newPath);
                    } else {
                        BasicMenuUI.this.setupPostTimer(menu);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }
    }

    class SelectMenuAction
    extends AbstractAction {
        SelectMenuAction() {
        }

        public void actionPerformed(ActionEvent event) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            MenuElement[] path = defaultManager.getSelectedPath();
            if (path.length > 0 && path[path.length - 1] == menu) {
                MenuElement[] newPath = new MenuElement[path.length + 1];
                System.arraycopy(path, 0, newPath, 0, path.length);
                newPath[path.length] = menu.getPopupMenu();
                defaultManager.setSelectedPath(newPath);
            }
        }
    }
}

