/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Menu
extends MenuItem
implements MenuContainer,
Serializable {
    private static transient long next_menu_number;
    private static final long serialVersionUID = -8809584163345499784L;
    private Vector items = new Vector();
    private boolean tearOff;
    private boolean isHelpMenu;
    private int menuSerializedDataVersion = 1;
    static final transient String separatorLabel = "-";

    public Menu() {
    }

    public Menu(String label) {
        this(label, false);
    }

    public Menu(String label, boolean isTearOff) {
        super(label);
        this.tearOff = isTearOff;
        if (label.equals("Help")) {
            this.isHelpMenu = true;
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int index) {
        return (MenuItem)this.items.elementAt(index);
    }

    public MenuItem add(MenuItem item) {
        MenuContainer parent = item.getParent();
        if (parent != null) {
            parent.remove(item);
        }
        this.items.addElement(item);
        item.setParent(this);
        if (this.peer != null) {
            item.addNotify();
            MenuPeer mp = (MenuPeer)this.peer;
            mp.addItem(item);
        }
        return item;
    }

    public void add(String label) {
        this.add(new MenuItem(label));
    }

    public void insert(MenuItem item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index is less than zero");
        }
        int count = this.getItemCount();
        if (index >= count) {
            this.add(item);
        } else {
            MenuContainer parent = item.getParent();
            if (parent != null) {
                parent.remove(item);
            }
            this.items.insertElementAt(item, index);
            item.setParent(this);
            MenuPeer peer = (MenuPeer)this.getPeer();
            if (peer == null) {
                return;
            }
            int i = count - 1;
            while (i >= index) {
                peer.delItem(i);
                --i;
            }
            item.addNotify();
            peer.addItem(item);
            i = index + 1;
            while (i <= count) {
                peer.addItem((MenuItem)this.items.elementAt(i));
                ++i;
            }
        }
    }

    public void insert(String label, int index) {
        this.insert(new MenuItem(label), index);
    }

    public void addSeparator() {
        this.add(new MenuItem(separatorLabel));
    }

    public void insertSeparator(int index) {
        this.insert(new MenuItem(separatorLabel), index);
    }

    public synchronized void remove(int index) {
        MenuItem item = (MenuItem)this.items.remove(index);
        MenuPeer mp = (MenuPeer)this.getPeer();
        if (mp != null) {
            mp.delItem(index);
            item.removeNotify();
        }
        item.setParent(null);
    }

    public void remove(MenuComponent item) {
        int index = this.items.indexOf(item);
        if (index == -1) {
            return;
        }
        this.remove(index);
    }

    public synchronized void removeAll() {
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            this.remove(0);
            ++i;
        }
    }

    public void addNotify() {
        MenuPeer peer = (MenuPeer)this.getPeer();
        if (peer == null) {
            peer = this.getToolkit().createMenu(this);
            this.setPeer(peer);
        }
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            MenuItem mi = (MenuItem)e.nextElement();
            mi.addNotify();
            peer.addItem(mi);
        }
        super.addNotify();
    }

    public void removeNotify() {
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            MenuItem mi = (MenuItem)e.nextElement();
            mi.removeNotify();
        }
        super.removeNotify();
    }

    public String paramString() {
        return ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "menu" + Menu.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_menu_number++;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private static final long serialVersionUID = 5228160894980069094L;

        protected AccessibleAWTMenu() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

