/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class BooleanType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 6};
    static final Set VALUE_SPACE = new TreeSet<String>(Arrays.asList("true", "false", "1", "0"));

    BooleanType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        if (!VALUE_SPACE.contains(value)) {
            throw new DatatypeException("invalid boolean value");
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        return "1".equals(literal) || "true".equals(literal) ? Boolean.TRUE : Boolean.FALSE;
    }
}

