#!/bin/sh
echo 'name: feldspar-language
version: 0.6.0.2
id: feldspar-language-0.6.0.2-53c9ef45ed2310c6d2b286d3215b80fd

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: Emil Axelsson <emax@chalmers.se>
            Anders Persson <anders.cj.persson@gmail.com>
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: A functional embedded language for DSP and parallelism
description: Feldspar (Functional Embedded Language for DSP and PARallelism)
             is an embedded DSL for describing digital signal processing
             algorithms. This package contains the language front-end and an
             interpreter.
category: Language
author: Functional programming group at Chalmers University of Technology
pkgpath: lang/feldspar/language
exposed: True
exposed-modules: Feldspar.Prelude Feldspar.Lattice Feldspar.Range
                 Feldspar.Algorithm.CRC Feldspar.Algorithm.FFT Feldspar.Core.Types
                 Feldspar.Core.Interpretation Feldspar.Core.Interpretation.Typed
                 Feldspar.Core.Constructs.Array Feldspar.Core.Constructs.Binding
                 Feldspar.Core.Constructs.Bits Feldspar.Core.Constructs.Complex
                 Feldspar.Core.Constructs.Condition
                 Feldspar.Core.Constructs.ConditionM
                 Feldspar.Core.Constructs.Conversion Feldspar.Core.Constructs.Eq
                 Feldspar.Core.Constructs.Error Feldspar.Core.Constructs.Floating
                 Feldspar.Core.Constructs.Fractional Feldspar.Core.Constructs.Future
                 Feldspar.Core.Constructs.Integral Feldspar.Core.Constructs.Literal
                 Feldspar.Core.Constructs.Logic Feldspar.Core.Constructs.Loop
                 Feldspar.Core.Constructs.Mutable
                 Feldspar.Core.Constructs.MutableArray
                 Feldspar.Core.Constructs.MutableReference
                 Feldspar.Core.Constructs.MutableToPure
                 Feldspar.Core.Constructs.NoInline Feldspar.Core.Constructs.Par
                 Feldspar.Core.Constructs.Num Feldspar.Core.Constructs.Ord
                 Feldspar.Core.Constructs.SizeProp
                 Feldspar.Core.Constructs.SourceInfo Feldspar.Core.Constructs.Trace
                 Feldspar.Core.Constructs.Tuple Feldspar.Core.Constructs.FFI
                 Feldspar.Core.Constructs.Save Feldspar.Core.Constructs
                 Feldspar.Core.Frontend.Array Feldspar.Core.Frontend.Binding
                 Feldspar.Core.Frontend.Bits Feldspar.Core.Frontend.Complex
                 Feldspar.Core.Frontend.Condition Feldspar.Core.Frontend.ConditionM
                 Feldspar.Core.Frontend.Conversion Feldspar.Core.Frontend.Eq
                 Feldspar.Core.Frontend.Error Feldspar.Core.Frontend.Floating
                 Feldspar.Core.Frontend.Fractional Feldspar.Core.Frontend.Future
                 Feldspar.Core.Frontend.Integral Feldspar.Core.Frontend.Literal
                 Feldspar.Core.Frontend.Logic Feldspar.Core.Frontend.Loop
                 Feldspar.Core.Frontend.Mutable Feldspar.Core.Frontend.MutableArray
                 Feldspar.Core.Frontend.MutableReference
                 Feldspar.Core.Frontend.MutableToPure
                 Feldspar.Core.Frontend.NoInline Feldspar.Core.Frontend.Par
                 Feldspar.Core.Frontend.Num Feldspar.Core.Frontend.Ord
                 Feldspar.Core.Frontend.Select Feldspar.Core.Frontend.SizeProp
                 Feldspar.Core.Frontend.SourceInfo Feldspar.Core.Frontend.Trace
                 Feldspar.Core.Frontend.Tuple Feldspar.Core.Frontend.FFI
                 Feldspar.Core.Frontend.Save Feldspar.Core.Frontend
                 Feldspar.Core.Collection Feldspar.Core Feldspar.BitVector
                 Feldspar.FixedPoint Feldspar.Future Feldspar.Matrix Feldspar.Option
                 Feldspar.Repa Feldspar.Stream Feldspar.Vector.Internal
                 Feldspar.Vector Feldspar.Vector.Push Feldspar.Wrap Feldspar.Par
                 Feldspar
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
hs-libraries: HSfeldspar-language-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: QuickAnnotate-0.6-de6a96240cbe34d04184955755dfb077
         QuickCheck-2.5.1.1-4a9242f1b61a140fe486a54f5467ba42
         array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         data-hash-0.1.0.0-352bb8bc936f31e81fe7d265a35e3ab2
         data-lens-2.10.2-e2e5e12add54c150ab5e7c90446f5024
         monad-par-0.3-84992568c57deca236f1a3901c1d0dd0
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         patch-combinators-0.1-13bbaf0b147b8cf7ea81311f40f7e26b
         syntactic-1.4-efbfc947e902e61b62c6d69c480de351
         tagged-0.4.4-886769b727dcf06f0418d254f5119104
         tuple-0.2.0.1-628cdb30992620da61b8c6df56aca340
         type-level-0.2.4-33fb4e9e8cb0fb20fa6852c58e327514
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html/feldspar-language.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
