#!/bin/sh
echo 'name: feldspar-compiler
version: 0.6.0.2
id: feldspar-compiler-0.6.0.2-7d7a8f2e14db335f1d3e76f3f1f4cd4b

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: deva@inf.elte.hu
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: Compiler for the Feldspar language
description: Feldspar (**F**unctional **E**mbedded **L**anguage for **DSP**
             and **PAR**allelism) is an embedded DSL for describing digital
             signal processing algorithms.
             This library (FeldsparCompiler) contains a prototype compiler
             that supports C code generation from programs written in this
             language both according to ANSI C and also targeted to a real
             DSP HW.
category: Compiler
author: Feldspar group,
        Eotvos Lorand University Faculty of Informatics
pkgpath: lang/feldspar/compiler
exposed: True
exposed-modules: Feldspar.Compiler.Imperative.Representation
                 Feldspar.Compiler.Imperative.FromCore
                 Feldspar.Compiler.Imperative.FromCore.Array
                 Feldspar.Compiler.Imperative.FromCore.Binding
                 Feldspar.Compiler.Imperative.FromCore.Condition
                 Feldspar.Compiler.Imperative.FromCore.ConditionM
                 Feldspar.Compiler.Imperative.FromCore.Error
                 Feldspar.Compiler.Imperative.FromCore.Future
                 Feldspar.Compiler.Imperative.FromCore.Interpretation
                 Feldspar.Compiler.Imperative.FromCore.Literal
                 Feldspar.Compiler.Imperative.FromCore.Loop
                 Feldspar.Compiler.Imperative.FromCore.Mutable
                 Feldspar.Compiler.Imperative.FromCore.MutableToPure
                 Feldspar.Compiler.Imperative.FromCore.NoInline
                 Feldspar.Compiler.Imperative.FromCore.Par
                 Feldspar.Compiler.Imperative.FromCore.Primitive
                 Feldspar.Compiler.Imperative.FromCore.SizeProp
                 Feldspar.Compiler.Imperative.FromCore.SourceInfo
                 Feldspar.Compiler.Imperative.FromCore.Tuple
                 Feldspar.Compiler.Imperative.FromCore.FFI
                 Feldspar.Compiler.Imperative.FromCore.Save
                 Feldspar.Compiler.Imperative.Frontend
                 Feldspar.Compiler.Imperative.TransformationInstance
                 Feldspar.Compiler.Imperative.Plugin.CollectFreeVars
                 Feldspar.Compiler.Imperative.Plugin.ConstantFolding
                 Feldspar.Compiler.Imperative.Plugin.Free
                 Feldspar.Compiler.Imperative.Plugin.IVars
                 Feldspar.Compiler.Imperative.Plugin.Unroll
                 Feldspar.Compiler.Imperative.Plugin.Naming
                 Feldspar.Compiler.Backend.C.CodeGeneration
                 Feldspar.Compiler.Backend.C.Plugin.PrettyPrint
                 Feldspar.Compiler.Backend.C.Plugin.Locator
                 Feldspar.Compiler.Backend.C.Plugin.BlockProgramHandler
                 Feldspar.Compiler.Backend.C.Plugin.TypeCorrector
                 Feldspar.Compiler.Backend.C.Plugin.TypeDefinitionGenerator
                 Feldspar.Compiler.Backend.C.Plugin.VariableRoleAssigner
                 Feldspar.Compiler.Backend.C.Plugin.Rule
                 Feldspar.Compiler.Backend.C.Library
                 Feldspar.Compiler.Backend.C.Options
                 Feldspar.Compiler.Backend.C.Platforms
                 Feldspar.Compiler.Frontend.Interactive.Interface
                 Feldspar.Compiler.Compiler Feldspar.Compiler.Error
                 Feldspar.Compiler Feldspar.Transformation
                 Feldspar.Transformation.Framework Feldspar.NameExtractor
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2
hs-libraries: HSfeldspar-compiler-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2/include
includes:
depends: MonadCatchIO-mtl-0.3.0.5-50eb20252600070062edde5090a7ae72
         ansi-terminal-0.5.5-8801f5127d93c5faa91ff9c937224633
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         directory-1.1.0.2-da0a8c62c2b42ae7a3b538f5fee58422
         feldspar-language-0.6.0.2-53c9ef45ed2310c6d2b286d3215b80fd
         filepath-1.3.0.0-f998e5510c76a98913f57b14b4f16c57
         haskell-src-exts-1.13.3-82aa5c9e8f66a01475bed22525f1f8b5
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         process-1.1.0.1-608c248c1528f46eb960a08cead77291
         syntactic-1.4-efbfc947e902e61b62c6d69c480de351
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-compiler-0.6.0.2/html/feldspar-compiler.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-compiler-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
