/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.security.auth.x500.X500Principal;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.verifier.BERProcessor;
import org.eclipse.osgi.internal.verifier.KeyStores;

public class PKCS7Processor
implements CertificateChain {
    private static final int[] SIGNEDDATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static final int[] MD5_OID = new int[]{1, 2, 840, 113549, 2, 5};
    private static final int[] MD2_OID = new int[]{1, 2, 840, 113549, 2, 2};
    private static final int[] SHA1_OID = new int[]{1, 3, 14, 3, 2, 26};
    private static final int[] DSA_OID = new int[]{1, 2, 840, 10040, 4, 1};
    private static final int[] RSA_OID = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static CertificateFactory certFact;
    private static KeyStores keyStores;
    private String certChain;
    private Certificate[] certificates;
    private boolean trusted;

    static {
        keyStores = new KeyStores();
        try {
            certFact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
    }

    String oid2String(int[] oid) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < oid.length) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(oid[i]);
            ++i;
        }
        return sb.toString();
    }

    String findEncryption(int[] encOid) throws NoSuchAlgorithmException {
        if (Arrays.equals(DSA_OID, encOid)) {
            return "DSA";
        }
        if (Arrays.equals(RSA_OID, encOid)) {
            return "RSA";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + this.oid2String(encOid));
    }

    String findDigest(int[] digestOid) throws NoSuchAlgorithmException {
        if (Arrays.equals(SHA1_OID, digestOid)) {
            return "SHA1";
        }
        if (Arrays.equals(MD5_OID, digestOid)) {
            return "MD5";
        }
        if (Arrays.equals(MD2_OID, digestOid)) {
            return "MD2";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + this.oid2String(digestOid));
    }

    public PKCS7Processor(String certChain, boolean trusted, byte[][] certificates) throws CertificateException {
        this.certChain = certChain;
        this.trusted = trusted;
        this.certificates = new Certificate[certificates.length];
        int i = 0;
        while (i < certificates.length) {
            this.certificates[i] = certFact.generateCertificate(new ByteArrayInputStream(certificates[i]));
            ++i;
        }
    }

    public PKCS7Processor(byte[] pkcs7, int pkcs7Offset, int pkcs7Length, byte[] data, int dataOffset, int dataLength) throws IOException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        boolean valid;
        X509Certificate xcert;
        StringBuffer sb;
        ArrayList<X509Certificate> certList;
        block12: {
            X500Principal subject;
            Collection<? extends Certificate> certs = certFact.generateCertificates(new ByteArrayInputStream(pkcs7, pkcs7Offset, pkcs7Length));
            BERProcessor bp = new BERProcessor(pkcs7, pkcs7Offset, pkcs7Length);
            bp = bp.stepInto();
            if (!Arrays.equals(bp.getObjId(), SIGNEDDATA_OID)) {
                throw new IOException("Not a valid PKCS#7 file");
            }
            bp.stepOver();
            bp = bp.stepInto();
            bp = bp.stepInto();
            bp.stepOver();
            bp.stepOver();
            bp.stepOver();
            bp.stepOver();
            if (bp.classOfTag == 0 && bp.tag == 1) {
                bp.stepOver();
            }
            bp = bp.stepInto();
            bp = bp.stepInto();
            bp.stepOver();
            BERProcessor issuerAndSN = bp.stepInto();
            X500Principal signerIssuer = new X500Principal(new ByteArrayInputStream(issuerAndSN.buffer, issuerAndSN.offset, issuerAndSN.endOffset - issuerAndSN.offset));
            issuerAndSN.stepOver();
            BigInteger sn = issuerAndSN.getIntValue();
            X509Certificate newSignerCert = null;
            for (X509Certificate x509Certificate : certs) {
                if (!x509Certificate.getIssuerX500Principal().equals(signerIssuer) || !x509Certificate.getSerialNumber().equals(sn)) continue;
                newSignerCert = x509Certificate;
                break;
            }
            if (newSignerCert == null) {
                throw new CertificateException("Signer certificate not in pkcs7block");
            }
            bp.stepOver();
            BERProcessor bERProcessor = bp.stepInto();
            String digest = this.findDigest(bERProcessor.getObjId());
            bp.stepOver();
            if (bp.classOfTag == 2) {
                bp.stepOver();
            }
            BERProcessor encryptionAlg = bp.stepInto();
            String enc = this.findEncryption(encryptionAlg.getObjId());
            bp.stepOver();
            byte[] signature = bp.getBytes();
            Signature sig = Signature.getInstance(String.valueOf(digest) + "with" + enc);
            sig.initVerify(newSignerCert.getPublicKey());
            sig.update(data, dataOffset, dataLength);
            if (!sig.verify(signature)) {
                throw new SignatureException("Signature doesn't verify");
            }
            certList = new ArrayList<X509Certificate>(1);
            certList.add(newSignerCert);
            sb = new StringBuffer();
            xcert = newSignerCert;
            X509Certificate prevCert = null;
            valid = true;
            do {
                try {
                    xcert.checkValidity();
                }
                catch (CertificateException certificateException) {
                    valid = false;
                }
                if (prevCert != null) {
                    prevCert.verify(xcert.getPublicKey());
                    certList.add(xcert);
                }
                prevCert = xcert;
                subject = xcert.getSubjectX500Principal();
                X500Principal issuer = xcert.getIssuerX500Principal();
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(subject);
                if (subject.equals(issuer)) break block12;
                xcert = null;
                for (X509Certificate x509Certificate : certs) {
                    if (!x509Certificate.getSubjectX500Principal().equals(issuer)) continue;
                    xcert = x509Certificate;
                }
            } while (xcert != null);
            throw new CertificateException(subject + " missing from chain");
        }
        this.certificates = certList.toArray(new Certificate[certList.size()]);
        this.trusted = valid && keyStores.isTrusted(xcert);
        this.certChain = sb.toString();
    }

    public Certificate getSigner() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[0];
    }

    public Certificate getRoot() {
        if (this.certificates == null || this.certificates.length == 0) {
            return null;
        }
        return this.certificates[this.certificates.length - 1];
    }

    public Certificate[] getCertificates() {
        return this.certificates;
    }

    public String getChain() {
        return this.certChain;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertificateChain)) {
            return false;
        }
        if (this.certificates == null) {
            return false;
        }
        CertificateChain chain = (CertificateChain)obj;
        if (this.trusted != chain.isTrusted() || (this.certChain == null ? chain.getChain() != null : !this.certChain.equals(chain.getChain()))) {
            return false;
        }
        Certificate[] otherCerts = chain.getCertificates();
        if (otherCerts == null || this.certificates.length != otherCerts.length) {
            return false;
        }
        int i = 0;
        while (i < this.certificates.length) {
            if (!this.certificates[i].equals(otherCerts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

